/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.impl.deploy;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.support.ConnectionSource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.vremanagement.vremodeler.db.DBInterface;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.VRE;
import org.gcube.vremanagement.vremodeler.impl.util.ResourceManagerPorts;
import org.gcube.vremanagement.vremodeler.impl.util.Util;
import org.gcube.vremanagement.vremodeler.utils.reports.Status;

public class UndeployVRE
extends Thread {
    private static GCUBELog logger = new GCUBELog(UndeployVRE.class);
    private ResourceManagerPorts ports;
    String resourceId;

    public UndeployVRE(String resourceId) {
        this.resourceId = resourceId;
    }

    @Override
    public void run() {
        try {
            logger.trace((Object)("called undeploy with scope " + ScopeProvider.instance.get()));
            Dao vreDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), VRE.class);
            VRE vre = (VRE)vreDao.queryForId((Object)this.resourceId);
            if (vre == null) {
                throw new Exception("vre with id " + this.resourceId + " not found");
            }
            if (Status.valueOf((String)vre.getStatus()) != Status.Deployed) {
                throw new Exception("the vre " + vre.getName() + " cannot be undeployed (the status isn't Deployed)");
            }
            logger.trace((Object)("undeploying vre " + vre.getName()));
            this.ports = ResourceManagerPorts.get(ScopeProvider.instance.get());
            String scopeToDispose = ScopeProvider.instance.get() + "/" + vre.getName();
            logger.trace((Object)("scope to dispose is " + scopeToDispose));
            String reportId = this.ports.getScopeController().disposeScope(scopeToDispose);
            String finalReport = this.getUndeployReport(reportId);
            logger.trace((Object)("UndeployReport; " + finalReport));
            if (Util.isSomethingFailed(finalReport)) {
                throw new Exception("something is FAILED deploying the vre " + vre.getName());
            }
            vre.setStatus(Status.Disposed.toString());
            vreDao.update((Object)vre);
            logger.trace((Object)("the vre " + vre.getName() + " has been undeplyed"));
        }
        catch (Exception e) {
            logger.error((Object)"error undeploying the VRE", (Throwable)e);
        }
    }

    private String getUndeployReport(String reportId) throws Exception {
        String report = null;
        do {
            try {
                Thread.sleep(20000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!Util.isDeploymentStatusFinished(report = this.ports.getReporter().getReport(reportId)));
        return report;
    }
}

