/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.impl.util;

import java.rmi.Remote;
import java.util.HashMap;
import java.util.List;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.handlers.GCUBEServiceHandler;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcemanager.stubs.binder.ResourceBinderPortType;
import org.gcube.vremanagement.resourcemanager.stubs.binder.service.ResourceBinderServiceAddressingLocator;
import org.gcube.vremanagement.resourcemanager.stubs.reporting.ReportingPortType;
import org.gcube.vremanagement.resourcemanager.stubs.reporting.service.ReportingServiceAddressingLocator;
import org.gcube.vremanagement.resourcemanager.stubs.scontroller.ScopeControllerPortType;
import org.gcube.vremanagement.resourcemanager.stubs.scontroller.service.ScopeControllerServiceAddressingLocator;
import org.gcube.vremanagement.vremodeler.impl.ServiceContext;

public class ResourceManagerPorts {
    private static GCUBELog logger = new GCUBELog(ResourceManagerPorts.class);
    private static HashMap<String, ResourceManagerPorts> mapPortInScope = new HashMap();
    private ResourceBinderPortType binder;
    private ScopeControllerPortType scopeController;
    private ReportingPortType reporter;

    public static ResourceManagerPorts get(String scope) throws Exception {
        if (!mapPortInScope.containsKey(scope.toString())) {
            mapPortInScope.put(scope.toString(), ResourceManagerPorts.getResourceMangerPT(scope));
        }
        return mapPortInScope.get(scope.toString());
    }

    public static void resetPorts() {
        mapPortInScope = new HashMap();
    }

    private ResourceManagerPorts(ResourceBinderPortType binder, ScopeControllerPortType scopeController, ReportingPortType reporter) {
        this.binder = binder;
        this.scopeController = scopeController;
        this.reporter = reporter;
    }

    public ResourceBinderPortType getBinder() {
        return this.binder;
    }

    public ScopeControllerPortType getScopeController() {
        return this.scopeController;
    }

    public ReportingPortType getReporter() {
        return this.reporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceManagerPorts getResourceMangerPT(String scope) throws Exception {
        ResourceManagerPorts ports = null;
        int attempt = 0;
        do {
            try {
                try {
                    Thread.sleep(30000L);
                }
                catch (Exception et) {
                    // empty catch block
                }
                ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
                GCUBERIQuery query = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
                query.setExpression("declare namespace is = 'http://gcube-system.org/namespaces/informationsystem/registry'; for $outer in collection(\"/db/Profiles/RunningInstance\")//Document/Data/is:Profile/Resource  let $scope:= $outer/Scopes/Scope[string() eq '" + scope.toString() + "'] " + " where count($scope)>0 " + " and $outer/Profile/ServiceName/string() eq 'ResourceManager' " + " and $outer/Profile/DeploymentData/Status/string() eq 'ready'" + " return $outer");
                List ris = client.execute((ISQuery)query, GCUBEScope.getScope((String)scope));
                if (ris.size() == 0) {
                    throw new GCUBEServiceHandler.NoQueryResultException();
                }
                ResourceBinderPortType binderPT = new ResourceBinderServiceAddressingLocator().getResourceBinderPortTypePort(((GCUBERunningInstance)ris.get(0)).getAccessPoint().getEndpoint("gcube/vremanagement/resourcemanager/binder"));
                binderPT = (ResourceBinderPortType)GCUBERemotePortTypeContext.getProxy((Remote)binderPT, (GCUBEScope)GCUBEScope.getScope((String)scope), (int)Integer.parseInt((String)ServiceContext.getContext().getProperty("resourceManagerTimeout", new boolean[]{true})), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                ScopeControllerPortType scopeControllerPT = new ScopeControllerServiceAddressingLocator().getScopeControllerPortTypePort(((GCUBERunningInstance)ris.get(0)).getAccessPoint().getEndpoint("gcube/vremanagement/resourcemanager/scopecontroller"));
                scopeControllerPT = (ScopeControllerPortType)GCUBERemotePortTypeContext.getProxy((Remote)scopeControllerPT, (GCUBEScope)GCUBEScope.getScope((String)scope), (int)Integer.parseInt((String)ServiceContext.getContext().getProperty("resourceManagerTimeout", new boolean[]{true})), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                ReportingPortType reporterPT = new ReportingServiceAddressingLocator().getReportingPortTypePort(((GCUBERunningInstance)ris.get(0)).getAccessPoint().getEndpoint("gcube/vremanagement/resourcemanager/reporting"));
                reporterPT = (ReportingPortType)GCUBERemotePortTypeContext.getProxy((Remote)reporterPT, (GCUBEScope)GCUBEScope.getScope((String)scope), (int)Integer.parseInt((String)ServiceContext.getContext().getProperty("resourceManagerTimeout", new boolean[]{true})), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                ports = new ResourceManagerPorts(binderPT, scopeControllerPT, reporterPT);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                logger.warn((Object)("the query for resourceManager returned no result, re-trying in 30 secs (" + attempt + ")"));
            }
            finally {
                ++attempt;
            }
        } while (ports == null && attempt < 10);
        if (attempt >= 10) {
            throw new Exception("no ResourceMaanger can be retrieved for scope " + scope);
        }
        return ports;
    }
}

