/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.whnmanager.jaxws.ws;

import java.util.Arrays;
import javax.jws.WebService;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ScopeGroup;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.resourcemanagement.whnmanager.api.WhnManager;
import org.gcube.resourcemanagement.whnmanager.api.exception.GCUBEUnrecoverableException;
import org.gcube.resourcemanagement.whnmanager.api.types.AddScopeInputParams;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.handlers.container.lifecycle.ProfilePublisher;
import org.gcube.vremanagement.whnmanager.utils.ValidationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(portName="WhnManagerIOPort", serviceName="gcube/vremanagement/ws/whnmanager", targetNamespace="http://gcube-system.org/", endpointInterface="org.gcube.resourcemanagement.whnmanager.api.WhnManager")
public class WhnManagerImpl
implements WhnManager {
    private static Logger logger = LoggerFactory.getLogger(WhnManagerImpl.class);

    public boolean addScope(AddScopeInputParams params) throws GCUBEUnrecoverableException {
        logger.trace("WHNManager: addScope method invokation");
        String scope = params.getScope();
        ValidationUtils.valid((String)"scope", (Object)scope);
        ApplicationContext context = ContextProvider.get();
        if (context != null) {
            HostingNode ghn = (HostingNode)context.container().profile(HostingNode.class);
            if (new ScopeBean(scope).is(ScopeBean.Type.VRE)) {
                logger.debug("addScope operation on VRE scope. Check if present VO scope");
                scope = new ScopeBean(scope).enclosingScope().toString();
                logger.debug("VO scope: " + scope);
            }
            if (!ValidationUtils.isPresent((Resource)ghn, (String)scope)) {
                ValidationUtils.addEnclosingScopesOnResource((Resource)ghn, (String)scope);
                logger.debug("addScope method: add scope " + scope + " to resource with id: " + ghn.id());
                ghn.scopes().asCollection().add(scope);
                ScopeGroup scopes = ghn.scopes();
                logger.debug(" resource will be  published in scopes: ");
                for (String scopeFound : scopes) {
                    logger.debug(" - " + scopeFound);
                }
                ContainerContext container = context.container();
                ProfilePublisher publisher = new ProfilePublisher(container);
                publisher.update();
            } else {
                logger.warn("the scope " + scope + " is already present on ghn profile with id: " + ghn.id());
            }
        } else {
            logger.warn("addScope method: context is null");
        }
        return true;
    }

    public boolean removeScope(String scope) throws GCUBEUnrecoverableException {
        logger.trace("WHN-Manager: removeScope method invokation");
        ValidationUtils.valid((String)"scope", (Object)scope);
        if (new ScopeBean(scope).is(ScopeBean.Type.VRE)) {
            logger.debug("this is a VRE scope. The request will be ignored ");
            return true;
        }
        ApplicationContext context = ContextProvider.get();
        if (context != null) {
            HostingNode ghn = (HostingNode)context.container().profile(HostingNode.class);
            if (ValidationUtils.isPresent((Resource)ghn, (String)scope)) {
                logger.debug("removeScope method: remove scope " + scope + " to resource with id: " + ghn.id());
                ContainerContext container = context.container();
                ProfilePublisher publisher = new ProfilePublisher(container);
                publisher.removeFrom(Arrays.asList(scope));
            } else {
                logger.warn("scope is not present in the resource");
            }
        } else {
            logger.warn("addScope method: context is null");
        }
        return true;
    }
}

