package org.gcube.resourcemanagement.whnmanager;

import java.net.HttpURLConnection;
import java.util.Map.Entry;
import java.util.Set;

import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.common.gxhttp.util.ContentUtils;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.resourcemanagement.whnmanager.utils.ValidationUtils;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.managers.ContextEvents;
import org.gcube.smartgears.security.SimpleCredentials;
import org.gcube.smartgears.security.defaults.DefaultAuthorizationProvider;
import org.gcube.smartgears.utils.InnerMethodName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path("/contexts")
public class ContextManager {

	private static Logger logger = LoggerFactory.getLogger(ContextManager.class);

	@PUT
	@Path("")
	public Response add(@FormParam("context") String context) {
		InnerMethodName.set("addContext");
		Secret secret = SecretManagerProvider.get();
		logger.trace(
				"WHNManager: addToContext method invokation with parameters context :{} and caller: {} curentContext: {}",
				context, secret.getOwner().getId(), secret.getContext());
		try {
			ValidationUtils.valid("context", context);
			ApplicationContext appContext = ContextProvider.get();
			if (context != null) {

				GXHTTPStringRequest request = GXHTTPStringRequest.newRequest("https://conductor.dev.d4science.org/api");
				try {

					request = request.path("workflow");
					for (Entry<String, String> entry : secret.getHTTPAuthorizationHeaders().entrySet())
						request = request.header(entry.getKey(), entry.getValue());

					SimpleCredentials credentials = ((DefaultAuthorizationProvider) appContext.container()
							.authorizationProvider()).getCredentials();

					HttpURLConnection response = request.post(String.format(
							" \"name\": \"ghn_client_add_to_contexts\",\n" + " \"input\" : {\n"
									+ "     \"client_id\" : \"%s\",\n" + "     \"context_list\" : [\"%s\"] }",
							credentials.getClientID(), context));

					if (response.getResponseCode() == Status.CREATED.getStatusCode()) {
						String body = ContentUtils.toString(ContentUtils.toByteArray(response.getInputStream()));
						logger.info("Returned response for remove scope {} ", body);
					} else throw new Exception("returned response is with status "+response.getResponseCode());

					appContext.container().events().fire(context, ContextEvents.ADD_CONTEXT_TO_CONTAINER);
				} catch (Exception e) {
					logger.error("error adding context {}", context, e);
					return Response.serverError().build();
				}

			} else {
				logger.error("context is null");
				return Response.status(Status.BAD_REQUEST).build();
			}
			return Response.ok().build();
		} catch (Throwable t) {
			logger.error("error adding context", t);
			throw new WebApplicationException(t);
		}
	}

	@DELETE
	@Path("")
	public Response remove(@QueryParam("context") String context) {
		InnerMethodName.set("removeContext");
		Secret secret = SecretManagerProvider.get();
		logger.trace(
				"WHNManager: removeFromContext method invokation with parameters context :{} and caller: {} curentContext: {}",
				context, secret.getOwner().getId(), secret.getContext());
		try {
			ValidationUtils.valid("context", context);
			ApplicationContext appContext = ContextProvider.get();
			if (context != null) {
				logger.trace("allowed container in context are {} ",
						appContext.container().authorizationProvider().getContexts());

				GXHTTPStringRequest request = GXHTTPStringRequest.newRequest("https://conductor.dev.d4science.org/api");
				try {

					request = request.path("workflow");
					for (Entry<String, String> entry : secret.getHTTPAuthorizationHeaders().entrySet())
						request = request.header(entry.getKey(), entry.getValue());

					SimpleCredentials credentials = ((DefaultAuthorizationProvider) appContext.container()
							.authorizationProvider()).getCredentials();

					HttpURLConnection response = request.post(String.format(
							" \"name\": \"ghn_client_remove_from_contexts\",\n" + " \"input\" : {\n"
									+ "     \"client_id\" : \"%s\",\n" + "     \"context_list\" : [\"%s\"] }",
							credentials.getClientID(), context));

					if (response.getResponseCode() == Status.CREATED.getStatusCode()) {
						String body = ContentUtils.toString(ContentUtils.toByteArray(response.getInputStream()));
						logger.info("Returned response for remove scope {} ", body);
					}

					appContext.container().events().fire(context, ContextEvents.REMOVE_CONTEXT_FROM_CONTAINER);
				} catch (Exception e) {
					logger.error("error removing context {}", context, e);
					return Response.serverError().build();
				}

			} else {
				logger.error("context is null");
				return Response.status(Status.BAD_REQUEST).build();
			}
			return Response.ok().build();
		} catch (Throwable t) {
			logger.error("error removing context", t);
			throw new WebApplicationException(t);
		}
	}

	@GET
	@Path("")
	@Produces(MediaType.APPLICATION_JSON)
	public String[] get() {
		InnerMethodName.set("getContext");
		ApplicationContext appContext = ContextProvider.get();
		Set<String> contexts = appContext.authorizationProvider().getContexts();
		return contexts.stream().toArray(String[]::new);
	}

}
