/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.whnmanager;

import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Predicate;
import org.gcube.common.keycloak.KeycloakClient;
import org.gcube.common.keycloak.KeycloakClientFactory;
import org.gcube.common.keycloak.model.TokenResponse;
import org.gcube.common.security.factories.AuthorizationProvider;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.event.publisher.AbstractHTTPWithJWTTokenAuthEventSender;
import org.gcube.event.publisher.Event;
import org.gcube.event.publisher.EventStatus;
import org.gcube.resourcemanagement.whnmanager.ContextManager;
import org.gcube.resourcemanagement.whnmanager.utils.ValidationUtils;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.security.SimpleCredentials;
import org.gcube.smartgears.utils.InnerMethodName;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/contexts")
public class ContextManager {
    private static Logger logger = LoggerFactory.getLogger(ContextManager.class);
    private static final String CONDUCTOR_URI = "https://conductor.cloud-dev.d4science.org/api/workflow/";
    private static final String ADD_CONTEXT_TASK = "ghn_client_add_to_context";
    private static final String REMOVE_CONTEXT_TASK = "ghn_client_remove_from_context";
    private static final int READ_TIMEOUT = 40000;
    private static final int CONNECTION_TIMEOUT = 40000;

    @PUT
    @Path(value="")
    public Response add(@FormParam(value="context") String context) {
        InnerMethodName.set((String)"addContext");
        Secret secret = SecretManagerProvider.get();
        logger.debug("WHNManager: addToContext method invokation with parameters context :{} and caller: {} curentContext: {}", new Object[]{context, secret.getOwner().getId(), secret.getContext()});
        try {
            this.executeTask(l -> l.contains(context), TaskType.ADD, context);
            ApplicationContext appContext = ContextProvider.get();
            appContext.container().events().fire((Object)context, new String[]{"AddContextToContainer"});
            return Response.ok().build();
        }
        catch (InvalidParameterException ip) {
            logger.warn("clientId already contains {}", (Object)context);
            return Response.noContent().build();
        }
        catch (IllegalArgumentException ia) {
            logger.warn("null context passed", (Throwable)ia);
            return Response.status((int)400, (String)"context parameter is null").build();
        }
        catch (Throwable t) {
            logger.error("error adding context", t);
            throw new WebApplicationException(t);
        }
    }

    @DELETE
    @Path(value="")
    public Response remove(@FormParam(value="context") String context) {
        InnerMethodName.set((String)"removeContext");
        Secret secret = SecretManagerProvider.get();
        logger.debug("WHNManager: removeFromContext method invokation with parameters context :{} and caller: {} curentContext: {}", new Object[]{context, secret.getOwner().getId(), secret.getContext()});
        try {
            this.executeTask(l -> !l.contains(context), TaskType.REMOVE, context);
            ApplicationContext appContext = ContextProvider.get();
            appContext.container().events().fire((Object)context, new String[]{"RemoveContextFromContainer"});
            return Response.ok().build();
        }
        catch (Throwable t) {
            logger.error("error removing context", t);
            throw new WebApplicationException(t);
        }
    }

    private EventStatus.Status executeTask(Predicate<Set<String>> notModifiablePredicate, TaskType type, String inputContext) throws Throwable {
        ValidationUtils.valid((String)"context", (Object)inputContext);
        ApplicationContext appContext = ContextProvider.get();
        AuthorizationProvider authProvider = appContext.container().authorizationProvider();
        SimpleCredentials credentials = (SimpleCredentials)authProvider.getCredentials();
        logger.debug("contexts already present in the container are {} executing task {}", (Object)authProvider.getContexts(), (Object)type.taskName);
        if (notModifiablePredicate.test(authProvider.getContexts())) {
            throw new InvalidParameterException();
        }
        HashMap<String, String> inputs = new HashMap<String, String>();
        inputs.put("client_id", credentials.getClientID());
        inputs.put("context", inputContext);
        Event event = new Event(type.taskName, type.taskName, appContext.name(), inputs);
        EventStatus.Status result = this.checkEventResult(credentials, event);
        logger.debug("{} exectured with result {}", (Object)type.taskName, (Object)result);
        if (result != EventStatus.Status.COMPLETED) {
            throw new Exception("error executing the workflow retuned with status " + result);
        }
        return result;
    }

    private EventStatus.Status checkEventResult(SimpleCredentials credentials, Event event) throws Throwable {
        JSONObject eventResult;
        Secret secret = SecretManagerProvider.get();
        AbstractHTTPWithJWTTokenAuthEventSender eventRequest = this.getAuthEventSender(credentials, secret);
        String result = eventRequest.sendAndGetResult(event);
        do {
            Thread.sleep(5000L);
        } while (EventStatus.Status.RUNNING == EventStatus.Status.valueOf((String)((String)(eventResult = eventRequest.retrive(result)).get((Object)"status"))));
        return EventStatus.Status.valueOf((String)((String)eventResult.get((Object)"status")));
    }

    @GET
    @Path(value="")
    @Produces(value={"application/json"})
    public String[] get() {
        InnerMethodName.set((String)"getContext");
        ApplicationContext appContext = ContextProvider.get();
        Set contexts = appContext.authorizationProvider().getContexts();
        return (String[])contexts.stream().toArray(String[]::new);
    }

    private AbstractHTTPWithJWTTokenAuthEventSender getAuthEventSender(SimpleCredentials credentials, Secret secret) throws Throwable {
        KeycloakClient client = KeycloakClientFactory.newInstance();
        TokenResponse tokenResponse = client.queryOIDCToken(secret.getContext(), credentials.getClientID(), credentials.getSecret());
        1 eventSender = new /* Unavailable Anonymous Inner Class!! */;
        eventSender.setConnectionTimeout(40000);
        eventSender.setReadTimeout(40000);
        return eventSender;
    }
}

