/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resources.federation.fhnmanager.cl.fwsimpl;

import java.net.URL;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.EndpointReference;
import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.resources.federation.fhnmanager.api.exception.ConnectorException;
import org.gcube.resources.federation.fhnmanager.api.exception.ISException;
import org.gcube.resources.federation.fhnmanager.cl.fwsimpl.FHNManagerClient;
import org.gcube.resources.federation.fhnmanager.cl.fwsimpl.FHNManagerClientAbstractPlugin;
import org.gcube.resources.federation.fhnmanager.cl.fwsimpl.RESTClientFilter;
import org.gcube.resources.federation.fhnmanager.cl.fwsimpl.ScopeTokenSetFilter;
import org.glassfish.jersey.filter.LoggingFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class FHNManagerClientPlugin
extends FHNManagerClientAbstractPlugin<WebTarget, FHNManagerClient> {
    private static Logger logger = LoggerFactory.getLogger(FHNManagerClientPlugin.class);
    private URL directUrl = null;

    public FHNManagerClientPlugin() {
        super("REST-API");
    }

    public FHNManagerClientPlugin(URL directURL) {
        super("REST-API");
        this.directUrl = directURL;
    }

    public WebTarget resolve(EndpointReference epr, ProxyConfig<?, ?> arg1) throws Exception {
        if (this.directUrl == null) {
            DOMResult result = new DOMResult();
            epr.writeTo((Result)result);
            Node node = result.getNode();
            Node child = node.getFirstChild();
            String address = child.getTextContent();
            logger.info("Endpoint resolved for FHNManagerService is \"" + address + "\"");
            this.directUrl = new URL(address);
        }
        Client client = ClientBuilder.newClient();
        client.register(ScopeTokenSetFilter.class);
        client.register(RESTClientFilter.class);
        client.register((Object)new LoggingFilter());
        return client.target(this.directUrl.toString());
    }

    public String namespace() {
        return null;
    }

    public Exception convert(Exception arg0, ProxyConfig<?, ?> arg1) {
        Throwable fhnException = arg0.getCause();
        if (fhnException instanceof ConnectorException || fhnException instanceof ISException) {
            return (Exception)fhnException;
        }
        return arg0;
    }

    public FHNManagerClient newProxy(ProxyDelegate<WebTarget> delegate) {
        return new FHNManagerClient(delegate);
    }
}

