package org.gcube.resources.federation.fhnmanager.impl;

import java.net.URI;
import java.util.Collection;
import java.util.Set;

import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

import org.gcube.resources.federation.fhnmanager.api.type.Node;
import org.gcube.resources.federation.fhnmanager.api.type.NodeTemplate;
import org.gcube.resources.federation.fhnmanager.api.type.ServiceProfile;
import org.gcube.resources.federation.fhnmanager.api.type.VMProvider;
import org.gcube.vomanagement.occi.FHNConnector;
import org.gcube.vomanagement.occi.datamodel.cloud.OSTemplate;
import org.gcube.vomanagement.occi.datamodel.cloud.VM;
import org.gcube.vomanagement.occi.exceptions.UnsupportedCredentialsTypeException;

import cz.cesnet.cloud.occi.api.exception.CommunicationException;


public interface FHNManagerBackend {

	Set<VMProvider> findVMProviders(String serviceProfileId, String ResourceTemplateId);

	VMProvider getVMProvider(String vmProviderId);

	Set<ServiceProfile> allServiceProfiles() throws Exception;

	Set<org.gcube.resources.federation.fhnmanager.api.type.ResourceTemplate> findResourceTemplate(String serviceProfileId, String vmProviderId);

	org.gcube.resources.federation.fhnmanager.api.type.ResourceTemplate getRsourceTemplate(String resourceTemplateId);

	Set<String> ListNodes(String VMProviderId);

	Set<Node> findNodes(String serviceProfileId, String VMProviderId);

	Node getNode(String NodeId, String VMProviderId);

	Response createNode(MultivaluedMap<String, String> formParams)
			throws UnsupportedCredentialsTypeException, CommunicationException;

	void startNode(String nodeId, String VMProviderId);

	void stopNode(String nodeId, String VMProviderId);

	void deleteNode(String nodeId, String VMProviderId);

	VM getNodeById(String nodeId, String vMProviderId);

	Set<VMProvider> getVMProviderFiltered(String serviceProfileId, String resourceTemplateId);

	VMProvider getVMProviderById(String vmProviderId);

	Set<ServiceProfile> getAllServiceProfiles();

	Set<org.gcube.resources.federation.fhnmanager.api.type.ResourceTemplate> getResourceTemplateFiltered(String serviceProfileId, String vmProviderId);

	org.gcube.resources.federation.fhnmanager.api.type.ResourceTemplate getResourceTemplateById(String resourceTemplateId);

	Set<String> getNodeFiltered(String serviceProfileId, String vMProviderId);

	Node createNodeFiltered(String serviceProfileId, String resourceTemplateId, String vmProviderId);

	void destroyVM(String nodeId, String vmProviderId);

}
