/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resources.federation.fhnmanager.startup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.ScopeGroup;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.federation.fhnmanager.impl.ISSynchronizer;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleEvent;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="plugin-registration-handler")
public class FHNManagerInitializator
extends ApplicationLifecycleHandler {
    private static Logger logger = LoggerFactory.getLogger(FHNManagerInitializator.class);
    private Thread thread = null;
    private ISSynchronizer isSyncrhonizer = null;

    public void onStart(ApplicationLifecycleEvent.Start e) {
        System.out.println("ON START CALLED ###################");
        List tokens = this.getScopes((ApplicationContext)e.context());
        logger.debug("Token are:" + tokens);
        LinkedList<String> scope = new LinkedList<String>();
        System.out.println("Scopes:");
        for (String t : tokens) {
            scope.add(this.getCurrentScope(t));
            System.out.println("\t" + scope);
        }
        this.isSyncrhonizer = new ISSynchronizer(scope, 30000L);
        this.thread = new Thread((Runnable)this.isSyncrhonizer);
        logger.debug("Starting thread: " + this.thread);
        this.thread.start();
        logger.debug("ISSynchronizer successfully started.");
    }

    public void onStop(ApplicationLifecycleEvent.Stop e) {
        System.out.println("ON STOP CALLED ###################");
        logger.debug("Stopping thread: " + this.thread);
        if (this.thread != null) {
            this.isSyncrhonizer.terminate();
            try {
                this.thread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            logger.debug("ISSynchronizer successfully stopped.");
        }
    }

    public String getCurrentScope(String token) {
        AuthorizationEntry authorizationEntry;
        try {
            authorizationEntry = Constants.authorizationService().get(token);
        }
        catch (Exception e) {
            return ScopeProvider.instance.get();
        }
        return authorizationEntry.getContext();
    }

    public List<String> getScopes(ApplicationContext applicationContext) {
        HashSet scopes;
        ScopeGroup scopeGroup = ((GCoreEndpoint)applicationContext.profile(GCoreEndpoint.class)).scopes();
        if (scopeGroup == null || scopeGroup.isEmpty()) {
            Set applicationScopes = applicationContext.configuration().startTokens();
            List containerScopes = applicationContext.container().configuration().startTokens();
            if (applicationScopes == null || applicationScopes.isEmpty()) {
                scopes = containerScopes;
                logger.debug("Application Scopes ({}). The Container Scopes ({}) will be used.", (Object)applicationScopes, (Object)scopes);
            } else {
                logger.debug("Container Scopes ({}). Application Scopes ({}) will be used.", (Object)containerScopes, (Object)applicationScopes);
                scopes = new HashSet(applicationScopes);
            }
        } else {
            scopes = scopeGroup.asCollection();
        }
        return new ArrayList<String>(scopes);
    }
}

