/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resources.federation.fhnmanager.service.rest;

import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.gcube.resources.federation.fhnmanager.api.FHNManager;
import org.gcube.resources.federation.fhnmanager.api.exception.FHNManagerException;
import org.gcube.resources.federation.fhnmanager.api.type.Node;
import org.gcube.resources.federation.fhnmanager.api.type.OccopusInfrastructure;
import org.gcube.resources.federation.fhnmanager.api.type.ResourceTemplate;
import org.gcube.resources.federation.fhnmanager.api.type.ServiceProfile;
import org.gcube.resources.federation.fhnmanager.api.type.VMProvider;
import org.gcube.resources.federation.fhnmanager.impl.FHNManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class RestFHNManagerImpl
implements FHNManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestFHNManagerImpl.class);
    private FHNManager service = new FHNManagerImpl();

    @GET
    @Path(value="/nodes")
    @Produces(value={"text/xml"})
    public Set<Node> findNodes(@QueryParam(value="serviceProfileId") String serviceProfileId, @QueryParam(value="vmProviderId") String vmProviderId) throws FHNManagerException, UnknownHostException {
        LOGGER.debug("Finding Node with serviceProfile=" + serviceProfileId + " and vmProviderId=" + vmProviderId);
        return this.service.findNodes(serviceProfileId, vmProviderId);
    }

    @GET
    @Path(value="/nodes/create")
    @Produces(value={"text/xml"})
    public Node createNode(@QueryParam(value="vmProviderId") String vmProviderId, @QueryParam(value="serviceProfileId") String serviceProfileId, @QueryParam(value="resourceTemplateId") String resourceTemplateId) throws FHNManagerException {
        LOGGER.debug("Creating Node with serviceProfile=" + serviceProfileId + ", VMProviderId=" + vmProviderId + " and ResourceTemplateId=" + resourceTemplateId);
        return this.service.createNode(vmProviderId, serviceProfileId, resourceTemplateId);
    }

    @GET
    @Path(value="/vmproviders")
    @Produces(value={"text/xml"})
    public Set<VMProvider> findVMProviders(@QueryParam(value="serviceProfileId") String serviceProfileId) throws FHNManagerException {
        LOGGER.debug("Finding VMProviders with serviceProfile=" + serviceProfileId);
        return this.service.findVMProviders(serviceProfileId);
    }

    @GET
    @Path(value="/vmproviders/{vmProviderId}")
    @Produces(value={"text/xml"})
    public VMProvider getVMProviderbyId(@PathParam(value="vmProviderId") String vmProviderId) throws FHNManagerException {
        return this.service.getVMProviderbyId(vmProviderId);
    }

    @GET
    @Path(value="/serviceprofiles")
    @Produces(value={"text/xml"})
    public Set<ServiceProfile> allServiceProfiles() throws FHNManagerException {
        return this.service.allServiceProfiles();
    }

    @GET
    @Path(value="/resourceTemplate")
    @Produces(value={"text/xml"})
    public Collection<ResourceTemplate> findResourceTemplate(@QueryParam(value="vmProviderId") String vmProviderId) throws FHNManagerException {
        LOGGER.debug("Finding ResourceTemplate with vmProviderId=" + vmProviderId);
        return this.service.findResourceTemplate(vmProviderId);
    }

    @GET
    @Path(value="/nodes/{nodeId}")
    @Produces(value={"text/xml"})
    public Node getNodeById(@PathParam(value="nodeId") String nodeId) throws FHNManagerException {
        LOGGER.debug("Finding Node with Id=" + nodeId);
        return this.service.getNodeById(nodeId);
    }

    @GET
    @Path(value="/nodes/start")
    @Produces(value={"text/xml"})
    public void startNode(@QueryParam(value="nodeId") String nodeId) throws FHNManagerException {
        this.service.startNode(nodeId);
    }

    @GET
    @Path(value="/nodes/stop")
    @Produces(value={"text/xml"})
    public void stopNode(@QueryParam(value="nodeId") String nodeId) throws FHNManagerException {
        this.service.stopNode(nodeId);
    }

    @GET
    @Path(value="/nodes/delete")
    @Produces(value={"text/xml"})
    public void deleteNode(@QueryParam(value="nodeId") String nodeId) throws FHNManagerException {
        this.service.deleteNode(nodeId);
    }

    @GET
    @Path(value="/infrastructures/create")
    @Produces(value={"text/xml"})
    public OccopusInfrastructure createInfrastructureByTemplate(@QueryParam(value="infrastructureTemplateId") String infrastructureTemplateId) {
        LOGGER.debug("Creating Occopus Infrastructure with infrastructureTemplateId = " + infrastructureTemplateId);
        return this.service.createInfrastructureByTemplate(infrastructureTemplateId);
    }

    @GET
    @Path(value="/infrastructures/delete")
    @Produces(value={"text/xml"})
    public void destroyInfrastructure(@QueryParam(value="infrastructureId") String infrastructureId) {
        LOGGER.debug("Destroying Occopus Infrastructure  with id = " + infrastructureId);
        this.service.destroyInfrastructure(infrastructureId);
    }

    @GET
    @Path(value="/infrastructures/{infraId}")
    @Produces(value={"text/xml"})
    public OccopusInfrastructure getInfrastructureById(@PathParam(value="infraId") String infraId) throws FHNManagerException {
        LOGGER.debug("Finding Infra with Id=" + infraId);
        return this.service.getInfrastructureById(infraId);
    }

    @GET
    @Path(value="/infrastructures")
    @Produces(value={"text/xml"})
    public Set<OccopusInfrastructure> getAllInfrastructures() throws FHNManagerException {
        LOGGER.debug("Finding Infrastructures:");
        return this.service.getAllInfrastructures();
    }
}

