/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.publisher.stubs.registry;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.stubs.registry.RegistryStub;
import org.gcube.informationsystem.publisher.stubs.registry.faults.CreateException;
import org.gcube.informationsystem.publisher.stubs.registry.faults.InvalidResourceException;
import org.gcube.informationsystem.publisher.stubs.registry.faults.RemoveException;
import org.gcube.informationsystem.publisher.stubs.registry.faults.ResourceDoesNotExistException;
import org.gcube.informationsystem.publisher.stubs.registry.faults.ResourceNotAcceptedException;
import org.gcube.informationsystem.publisher.stubs.registry.faults.UpdateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectorStubs
implements RegistryStub {
    private static Logger log = LoggerFactory.getLogger(CollectorStubs.class);
    public static final String TOKEN_HEADER_ENTRY = "gcube-token";
    public static final String SCOPE_HEADER_ENTRY = "gcube-scope";
    private String endopoint;

    public CollectorStubs(String endopoint) {
        this.endopoint = endopoint;
    }

    @Override
    public void create(String profile, String type) throws InvalidResourceException, ResourceNotAcceptedException, CreateException {
        StringBuilder callUrl = new StringBuilder(this.endopoint).append("/").append(type);
        try {
            URL url = new URL(callUrl.toString());
            HttpURLConnection connection = this.makeRequest(url, "POST");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-type", "text/xml");
            try (BufferedOutputStream os = new BufferedOutputStream(connection.getOutputStream());){
                ((OutputStream)os).write(profile.getBytes());
            }
            if (connection.getResponseCode() != 200) {
                throw new Exception("error creating resource " + connection.getResponseCode());
            }
        }
        catch (Exception e) {
            log.error("error on create", (Throwable)e);
            throw new RemoveException(e.getMessage());
        }
    }

    @Override
    public void update(String id, String type, String profile) throws InvalidResourceException, ResourceNotAcceptedException, UpdateException {
        StringBuilder callUrl = new StringBuilder(this.endopoint).append("/").append(type).append("/").append(id);
        try {
            URL url = new URL(callUrl.toString());
            HttpURLConnection connection = this.makeRequest(url, "PUT");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-type", "text/xml");
            try (BufferedOutputStream os = new BufferedOutputStream(connection.getOutputStream());){
                ((OutputStream)os).write(profile.getBytes());
            }
            if (connection.getResponseCode() != 200) {
                throw new Exception("error updating resource " + connection.getResponseCode());
            }
        }
        catch (Exception e) {
            log.error("error on remove", (Throwable)e);
            throw new RemoveException(e.getMessage());
        }
    }

    @Override
    public void remove(String id, String type) throws ResourceDoesNotExistException, RemoveException {
        StringBuilder callUrl = new StringBuilder(this.endopoint).append("/").append(type).append("/").append(id);
        try {
            URL url = new URL(callUrl.toString());
            HttpURLConnection connection = this.makeRequest(url, "DELETE");
            connection.setDoInput(true);
            if (connection.getResponseCode() != 200) {
                log.info("response code is not 200");
                throw new Exception("error removing resource with id " + id);
            }
        }
        catch (Exception e) {
            log.error("error on remove", (Throwable)e);
            throw new RemoveException(e.getMessage());
        }
    }

    private HttpURLConnection makeRequest(URL url, String method) throws Exception {
        HttpURLConnection connection = url.toString().startsWith("https://") ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
        if (SecurityTokenProvider.instance.get() != null) {
            connection.setRequestProperty(TOKEN_HEADER_ENTRY, SecurityTokenProvider.instance.get());
        } else if (ScopeProvider.instance.get() != null) {
            connection.setRequestProperty(SCOPE_HEADER_ENTRY, ScopeProvider.instance.get());
        } else {
            throw new RuntimeException("Collector requires authorization (via token or scope)");
        }
        connection.setRequestMethod(method);
        return connection;
    }
}

