/**
 * 
 */
package org.gcube.resourcemanagement.updater;

import static org.gcube.common.resources.gcore.Resources.print;
import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.AccessPoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;

/**
 * @author Roberto Cirillo (ISTI-CNR) 2018
 *
 */
public class Utils {
	
	protected static Properties loadProperties(String filePath) throws IOException {
		//load properties
		InputStream input=null;
		Properties prop = new Properties();
		try {
			String propFileName = filePath;
			input = AccessPointUpdater.class.getClassLoader().getResourceAsStream(propFileName);
			if (input != null) {
				prop.load(input);
			} else {
				throw new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
			}
 			// get the property value and print it out
			String user = prop.getProperty("user");
			String r = prop.getProperty("R");
			String result = "R version= " + r;
			System.out.println("result: "+result);
		} finally{
        	if(input!=null){
        		try {
        			input.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
        	}
        }
		return prop;
			
	}
	
	protected static void update(Resource resource) {
		String currentScope=ScopeProvider.instance.get();
		System.out.println("update resource in scope "+currentScope);
//		print(resource);
		RegistryPublisher rp=RegistryPublisherFactory.create();
		rp.vosUpdate(resource);
	}

	protected static ServiceEndpoint getResource(String scope, String category, String name) {
		ScopeProvider.instance.set(scope);
		System.out.println("find from "+scope+ " and Category: "+category+" the following name "+name);
		SimpleQuery query = queryFor(ServiceEndpoint.class);
		query.addCondition("$resource/Profile/Category/text() eq '"+category+"'");
		DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);
		List<ServiceEndpoint> se = client.submit(query);
		return se.get(0);
	}

	protected static AccessPoint getAccessPoint(ServiceEndpoint endpoint, String accessPointName) {
		System.out.println("finding the following accessPoint "+accessPointName);
		SimpleQuery query = queryFor(ServiceEndpoint.class);
		Group<AccessPoint> accesspoints=endpoint.profile().accessPoints();
		for (AccessPoint point: accesspoints){
//			System.out.println("checking ap: "+point.name());
			if (point.name().equals(accessPointName)){
				System.out.println("AccessPoint found: "+point.name()+ " address: "+point.address());
				return point;
			}
		}
		return null;
	}



}
