/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.publisher.utils;

import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ResourceMediator;
import org.gcube.common.resources.gcore.ScopeGroup;
import org.gcube.common.scope.impl.ScopeBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationUtils {
    private static final Logger log = LoggerFactory.getLogger(ValidationUtils.class);

    public static void valid(String name, Object object) {
        if (object == null) {
            throw new IllegalArgumentException(name + " is null");
        }
    }

    public static <R extends Resource> boolean isPresent(R resource, String currentScope) {
        ScopeGroup<String> scopes = resource.scopes();
        boolean founded = false;
        for (String scope : scopes) {
            if (!scope.equals(currentScope)) continue;
            founded = true;
        }
        if (founded) {
            throw new IllegalArgumentException(" scope " + currentScope + " is already present in resource");
        }
        return false;
    }

    public static <T extends Resource> void addEnclosingScopesOnResource(T resource, String scope) {
        if (new ScopeBean(scope).is(ScopeBean.Type.VRE)) {
            String voScope = new ScopeBean(scope).enclosingScope().toString();
            String infraScope = new ScopeBean(voScope).enclosingScope().toString();
            log.debug("adding " + voScope + " to the resource " + resource.id());
            ResourceMediator.setScope(resource, voScope);
            log.debug("adding " + infraScope + " to the resource " + resource.id());
            ResourceMediator.setScope(resource, infraScope);
        } else if (new ScopeBean(scope).is(ScopeBean.Type.VO)) {
            String infraScope = new ScopeBean(scope).enclosingScope().toString();
            log.debug("adding " + infraScope + " to the resource " + resource.id());
            ResourceMediator.setScope(resource, infraScope);
        }
    }

    public static <T extends Resource> boolean isCompatibleScopeForRemove(T resource, String scope) {
        log.info("scope: {} check if update is needed inr resource: {}", (Object)scope, (Object)resource.id());
        if (resource.scopes().size() == 0) {
            return true;
        }
        if (new ScopeBean(scope).is(ScopeBean.Type.VRE)) {
            log.debug(" " + scope + " is a VRE scope");
            if (ValidationUtils.anotherBrotherVREOrVOOnResource(resource, scope)) {
                log.debug("found another VRE  or VO scope on the resource: ");
                return false;
            }
            return true;
        }
        if (new ScopeBean(scope).is(ScopeBean.Type.VO)) {
            log.debug(" " + scope + " is a VO scope");
            return !ValidationUtils.anotherSonVREOnResource(resource, scope);
        }
        return !ValidationUtils.anotherInfraScopeOnResource(resource, scope);
    }

    public static <T extends Resource> boolean anotherBrotherVREOrVOOnResource(T resource, String scope) {
        if (!new ScopeBean(scope).is(ScopeBean.Type.VRE)) {
            throw new IllegalArgumentException("anotherBrotherVREOrVOOnResource method: the input scope must be a VRE scope");
        }
        String enclosedScope = new ScopeBean(scope).enclosingScope().toString();
        log.debug("VO scope " + enclosedScope);
        for (String s : resource.scopes()) {
            log.debug(" check scope " + s);
            if (ValidationUtils.isChildScope(enclosedScope, s)) {
                log.debug("the scope " + s + " is another VRE scope defined in the resource. Not Remove needed ");
                return true;
            }
            if (enclosedScope == null || !enclosedScope.toString().equals(s)) continue;
            log.debug("the scope " + s + " is the father VO scope defined in the resource. Not Remove needed ");
            return true;
        }
        log.debug("other brother VRE scope or VO scope not found on the resource ");
        return false;
    }

    public static <T extends Resource> boolean anotherSonVREOnResource(T resource, String scope) {
        if (!new ScopeBean(scope).is(ScopeBean.Type.VO)) {
            throw new IllegalArgumentException("anotherSonVREOnResource method: the input scope must be a VO scope");
        }
        for (String s : resource.scopes()) {
            if (!ValidationUtils.isChildScope(scope, s)) continue;
            log.debug("the scope " + s + " is another VO scope defined in the resource ");
            return true;
        }
        return false;
    }

    public static boolean isChildScope(String fatherScope, String sonScope) {
        ScopeBean currentEnclosedScope = new ScopeBean(sonScope).enclosingScope();
        if (currentEnclosedScope != null && currentEnclosedScope.toString().equals(fatherScope)) {
            log.debug("check scope" + fatherScope + ": found another son VRE scope " + sonScope);
            return true;
        }
        return false;
    }

    public static <T extends Resource> boolean anotherInfraScopeOnResource(T resource, String scope) {
        if (!new ScopeBean(scope).is(ScopeBean.Type.INFRASTRUCTURE)) {
            throw new IllegalArgumentException("anotherInfraScopeOnResource method: the input scope must be a INFRASTRUCTURE scope");
        }
        String infraScopeFound = null;
        for (String s : resource.scopes()) {
            while (new ScopeBean(s).enclosingScope() != null) {
                s = new ScopeBean(s).enclosingScope().toString();
            }
            infraScopeFound = s;
            if (!infraScopeFound.equals(scope)) continue;
            log.debug("check scope" + scope + ": found another scope on infra " + s);
            return true;
        }
        return false;
    }
}

