/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.datafusion.datatypes;

import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gcube.search.datafusion.datatypes.PositionalRecordWrapper;
import org.gcube.search.datafusion.helpers.RecordHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSFusedIterator
implements Iterator<PositionalRecordWrapper>,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<Iterator<GenericRecord>> iters;
    private GenericRecord[] vals;
    private int ranked = 0;
    private long[] counts;
    private final int n;
    private int prevMaxIdx = -1;
    private long recsProduced = 0L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RSFusedIterator.class);

    public static Iterator<GenericRecord> locatorToIterator(URI locator) throws GRS2ReaderException {
        ForwardReader reader = new ForwardReader(locator);
        LOGGER.info("getting iterator for locator : " + locator.toString());
        return reader.iterator();
    }

    public static List<Iterator<GenericRecord>> locatorsToItersList(URI[] locators) throws GRS2ReaderException {
        LOGGER.info("getting iterators for locators : ");
        LOGGER.info("---------------------------------");
        ArrayList<Iterator<GenericRecord>> iters = new ArrayList<Iterator<GenericRecord>>();
        for (URI loc : locators) {
            iters.add(RSFusedIterator.locatorToIterator(loc));
        }
        LOGGER.info("---------------------------------");
        return iters;
    }

    public RSFusedIterator(URI[] locators) throws GRS2ReaderException {
        this(locators, -1);
    }

    public RSFusedIterator(URI[] locators, int n) throws GRS2ReaderException {
        this(RSFusedIterator.locatorsToItersList(locators), n);
    }

    public RSFusedIterator(List<Iterator<GenericRecord>> streamIters) {
        this(streamIters, -1);
    }

    public RSFusedIterator(List<Iterator<GenericRecord>> streamIters, int n) {
        this.iters = streamIters;
        this.vals = new GenericRecord[streamIters.size()];
        this.counts = new long[streamIters.size()];
        this.n = n;
        LOGGER.info("Initializing Fused Iterator for : " + streamIters.size() + " iterators and n :" + n);
        for (int i = 0; i != streamIters.size(); ++i) {
            this.vals[i] = streamIters.get(i).hasNext() ? streamIters.get(i).next() : null;
            this.counts[i] = 0L;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.ranked == this.n) {
            return false;
        }
        for (int i = 0; i != this.vals.length; ++i) {
            if (i == this.prevMaxIdx || this.vals[i] == null) continue;
            return true;
        }
        if (this.prevMaxIdx == -1) {
            return false;
        }
        return this.iters.get(this.prevMaxIdx).hasNext();
    }

    @Override
    public PositionalRecordWrapper next() {
        if (this.prevMaxIdx != -1) {
            this.vals[this.prevMaxIdx] = this.iters.get(this.prevMaxIdx).hasNext() ? this.iters.get(this.prevMaxIdx).next() : null;
        }
        GenericRecord res = null;
        Float max = Float.valueOf(-1.0f);
        int maxIdx = -1;
        for (int i = 0; i != this.vals.length; ++i) {
            LOGGER.info("checking : " + this.vals[i] + " i : " + i + " , vals length : " + this.vals.length);
            if (this.vals[i] == null) continue;
            Float rank = RecordHelper.getRank(this.vals[i]);
            LOGGER.info("rank : " + rank);
            if (rank != null && (max == null || !(rank.floatValue() > max.floatValue()))) continue;
            max = rank;
            maxIdx = i;
            res = this.vals[i];
        }
        if (max != null) {
            ++this.ranked;
        }
        int n = maxIdx;
        this.counts[n] = this.counts[n] + 1L;
        this.prevMaxIdx = maxIdx;
        PositionalRecordWrapper prw = new PositionalRecordWrapper(this.counts[maxIdx], res);
        ++this.recsProduced;
        LOGGER.trace("records produced : " + this.recsProduced);
        LOGGER.trace("records ranked   : " + this.ranked);
        return prw;
    }

    @Override
    public void remove() {
    }
}

