/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.datasource.predefined;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.FileField;
import gr.uoa.di.madgik.grs.record.field.FileFieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.FieldNaming;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.contenttype.ContentTypeEvaluator;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.datasource.DataSource;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathDataSource
extends DataSource {
    private static Logger log = LoggerFactory.getLogger((String)PathDataSource.class.getName());
    private String sourcePath;
    private String[] folderContents;

    public PathDataSource(String input, Map<String, String> inputParameters) throws Exception {
        super(input, inputParameters);
        this.fieldDefs = PathDataSource.initializeSchema(this.filterMask);
        this.writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), new RecordDefinition[]{new GenericRecordDefinition(this.fieldDefs)}, RecordWriter.DefaultBufferCapacity, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
        this.sourcePath = this.input;
        File source = new File(this.sourcePath);
        if (source.isDirectory()) {
            if (!this.sourcePath.endsWith(File.pathSeparator)) {
                this.sourcePath = this.sourcePath + File.separator;
            }
            this.folderContents = source.list();
        } else if (source.exists()) {
            this.folderContents = new String[]{source.getName()};
            this.sourcePath = this.sourcePath.substring(0, this.sourcePath.lastIndexOf("/") + 1);
        }
        if (this.folderContents == null) {
            log.error(this.folderContents + ": Either dir does not exist or is not a directory");
            throw new Exception(this.folderContents + ": Either dir does not exist or is not a directory");
        }
        log.info("Ininializing local data source at: " + input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long start;
        Thread.currentThread().setName(PathDataSource.class.getName());
        long firstInputStop = start = Calendar.getInstance().getTimeInMillis();
        long firstOutputStop = start;
        int rc = 0;
        try {
            for (String fileName : this.folderContents) {
                String localFileName = this.sourcePath + fileName;
                File localFile = new File(localFileName);
                if (localFile.isDirectory()) continue;
                if (rc == 0) {
                    firstInputStop = Calendar.getInstance().getTimeInMillis();
                }
                ArrayList<Object> fieldList = new ArrayList<Object>();
                block17: for (FieldDefinition field : this.fieldDefs) {
                    switch (FieldNaming.LocalFieldName.valueOf(field.getName())) {
                        case id: {
                            fieldList.add(new StringField(fileName));
                            continue block17;
                        }
                        case bytestream: {
                            fieldList.add(new FileField(localFile));
                            continue block17;
                        }
                        case mimeType: {
                            fieldList.add(new StringField(ContentTypeEvaluator.getContentType(localFile)));
                            continue block17;
                        }
                        default: {
                            log.warn("Unexpected field: " + field.getName());
                        }
                    }
                }
                GenericRecord rec = new GenericRecord();
                rec.setFields(fieldList.toArray(new Field[fieldList.size()]));
                log.debug("Returning next row with id: " + fileName);
                if (!this.writer.importRecord((Record)rec, this.timeout, this.timeUnit)) {
                    if (this.writer.getStatus() == IBuffer.Status.Open) {
                        log.warn("Consumer has timed out");
                    }
                    break;
                }
                if (++rc != 1) continue;
                firstOutputStop = Calendar.getInstance().getTimeInMillis();
            }
        }
        catch (Exception e) {
            log.error("Error during datasource retrieval. Closing", (Throwable)e);
        }
        finally {
            try {
                this.writer.close();
            }
            catch (Exception ee) {}
        }
        long closeStop = Calendar.getInstance().getTimeInMillis();
        log.info("DATASOURCE OPERATOR:Produced first result in " + (firstOutputStop - start) + " milliseconds\n" + "Produced last result in " + (closeStop - start) + " milliseconds\n" + "Produced " + rc + " results\n" + "Production rate was " + (float)rc / (float)(closeStop - start) * 1000.0f + " records per second");
    }

    @Override
    public URI getLocator() {
        if (this.writer != null) {
            try {
                return this.writer.getLocator();
            }
            catch (GRS2WriterException e) {
                log.error("Could not retrieve locator", (Throwable)e);
            }
        }
        return null;
    }

    private static FieldDefinition[] initializeSchema(String filterMask) {
        ArrayList<Object> fieldDefsList = new ArrayList<Object>();
        if (filterMask == null) {
            filterMask = "[";
            for (FieldNaming.LocalFieldName localFieldName : FieldNaming.LocalFieldName.values()) {
                filterMask = filterMask + localFieldName.name() + ", ";
            }
            filterMask = filterMask.substring(0, filterMask.length() - 2);
            filterMask = filterMask + "]";
        }
        if (filterMask.replaceAll("[\\[\\],\\s]", "").matches("\\d*")) {
            for (String string : filterMask.replaceAll("[\\[\\]\\s]", "").split(",")) {
                int index = Integer.parseInt(string);
                if (index >= FieldNaming.LocalFieldName.values().length) {
                    log.warn("Filter mask out of range");
                    continue;
                }
                if (FieldNaming.LocalFieldName.values()[index].equals((Object)FieldNaming.LocalFieldName.bytestream)) {
                    fieldDefsList.add(new FileFieldDefinition(FieldNaming.LocalFieldName.values()[index].name()));
                    continue;
                }
                fieldDefsList.add(new StringFieldDefinition(FieldNaming.LocalFieldName.values()[index].name()));
            }
        } else {
            for (String string : filterMask.replaceAll("[\\[\\]\\s]", "").split(",")) {
                try {
                    switch (FieldNaming.LocalFieldName.valueOf(string)) {
                        case bytestream: {
                            fieldDefsList.add(new FileFieldDefinition(FieldNaming.LocalFieldName.valueOf(string).name()));
                            break;
                        }
                        default: {
                            fieldDefsList.add(new StringFieldDefinition(FieldNaming.LocalFieldName.valueOf(string).name()));
                            break;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    log.warn("Filter mask out of range for value: " + string);
                }
            }
        }
        log.info("ResultSet schema that will be used: " + fieldDefsList);
        return fieldDefsList.toArray(new FieldDefinition[fieldDefsList.size()]);
    }
}

