/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.hive.plan;

import gr.uoa.di.madgik.hive.plan.Functionality;
import gr.uoa.di.madgik.hive.plan.PlanNode;
import gr.uoa.di.madgik.hive.utils.XMLBeautifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class OperatorNode
extends PlanNode {
    private Functionality functionality = null;
    private ArrayList<PlanNode> children = new ArrayList();

    public OperatorNode(Functionality functionality, HashMap<String, String> functionalArgs, ArrayList<PlanNode> children) {
        super(functionalArgs);
        this.children = children;
        this.functionality = functionality;
        if (children != null) {
            for (PlanNode ch : children) {
                ch.setParent(this);
            }
        }
    }

    public OperatorNode(OperatorNode node) {
        this(node.functionality, node.functionalArgs, new ArrayList<PlanNode>());
        for (PlanNode c : node.getChildren()) {
            if (c instanceof OperatorNode) {
                c = new OperatorNode((OperatorNode)c);
            }
            this.children.add(c);
        }
    }

    public void setChildren(ArrayList<PlanNode> children) {
        this.children = children;
        for (PlanNode ch : children) {
            ch.setParent(this);
        }
    }

    public ArrayList<PlanNode> getChildren() {
        return this.children;
    }

    public void addChild(PlanNode child) {
        this.children.add(child);
        child.setParent(this);
    }

    public Functionality getFunctionality() {
        return this.functionality;
    }

    public void setFunctionality(Functionality functionality) {
        this.functionality = functionality;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperatorNode other = (OperatorNode)obj;
        if (!this.functionality.equals((Object)other.functionality)) {
            return false;
        }
        if (!this.functionalArgs.equals(other.functionalArgs)) {
            return false;
        }
        HashSet<PlanNode> childrenSet = new HashSet<PlanNode>(this.children);
        HashSet<PlanNode> otherChildrenSet = new HashSet<PlanNode>(other.children);
        return childrenSet.equals(otherChildrenSet);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.functionality == null ? 0 : this.functionality.hashCode());
        hash = 31 * hash + (this.functionalArgs == null ? 0 : this.functionalArgs.hashCode());
        hash = 31 * hash + (this.children == null ? 0 : this.children.hashCode());
        return hash;
    }

    public String toString() {
        Pattern INVALID_XML_CHARS = Pattern.compile("[^\\u0009\\u000A\\u000D\\u0020-\\uD7FF\\uE000-\\uFFFD\ud800\udc00-\udbff\udfff]");
        StringBuilder result = new StringBuilder();
        result.append("<Operation>");
        result.append("<Functionality>" + (Object)((Object)this.functionality) + "</Functionality>");
        result.append("<Indications>");
        for (Map.Entry entry : this.functionalArgs.entrySet()) {
            result.append((String)entry.getKey() + "-" + StringEscapeUtils.escapeXml((String)INVALID_XML_CHARS.matcher(((String)entry.getValue()).length() < 256 ? (String)entry.getValue() : ((String)entry.getValue()).substring(0, 255) + "...").replaceAll("")) + ", ");
        }
        if (!this.functionalArgs.isEmpty()) {
            result.delete(result.length() - 2, result.length());
        }
        result.append("</Indications>");
        result.append("<Children>");
        if (this.children != null) {
            for (PlanNode child : this.children) {
                result.append(child.toString());
            }
        }
        result.append("</Children>");
        result.append("</Operation>");
        return XMLBeautifier.prettyPrintXml(result.toString());
    }
}

