package org.gcube.opensearch.client.library.plugins;

import javax.xml.ws.EndpointReference;

import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.fw.plugin.Plugin;
import org.gcube.common.clients.stubs.jaxws.StubFactory;
import org.gcube.opensearch.client.library.proxies.OpenSearchDataSourceFactoryCLDefaultProxy;
import org.gcube.opensearch.client.library.proxies.OpenSearchDataSourceFactoryCLProxyI;
import org.gcube.opensearch.client.library.stubs.OpenSearchDataSourceFactoryStub;
import org.gcube.opensearch.client.library.util.OpenSearchDataSourceCLConstants;

/**
 * DTS Client Library plugin exposes information that allows CL Framework
 * components to act on behalf of DTS CL. 
 * 
 * @author john.gerbesiotis - DI NKUA
 * 
 */
public class OpenSearchDataSourceFactoryCLPlugin implements Plugin<OpenSearchDataSourceFactoryStub, OpenSearchDataSourceFactoryCLProxyI> {

	@Override
	public String name() {
		return OpenSearchDataSourceCLConstants.FACTORYNAME;
	}

	@Override
	public String namespace() {
		return OpenSearchDataSourceCLConstants.NAMESPACE;
	}

	@Override
	public String serviceClass() {
		return OpenSearchDataSourceCLConstants.gcubeClass;
	}

	@Override
	public String serviceName() {
		return OpenSearchDataSourceCLConstants.gcubeName;
	}
	
	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		return fault;
	}

	@Override
	public OpenSearchDataSourceFactoryStub resolve(EndpointReference reference, ProxyConfig<?, ?> proxyConfig) throws Exception {
		return StubFactory.stubFor(OpenSearchDataSourceCLConstants.osdsf).at(reference);
	}

	@Override
	public OpenSearchDataSourceFactoryCLProxyI newProxy(ProxyDelegate<OpenSearchDataSourceFactoryStub> delegate) {
		return new OpenSearchDataSourceFactoryCLDefaultProxy(delegate);
	}

}
