package org.gcube.opensearch.client.library.util;

import static org.gcube.common.clients.stubs.jaxws.GCoreServiceBuilder.*;

import java.util.concurrent.TimeUnit;

import org.gcube.common.clients.stubs.jaxws.GCoreService;
import org.gcube.opensearch.client.library.stubs.OpenSearchDataSourceFactoryStub;
import org.gcube.opensearch.client.library.stubs.OpenSearchDataSourceStub;

import javax.xml.namespace.QName;

public class OpenSearchDataSourceCLConstants {
	public static final int DEFAULT_TIMEOUT= (int) TimeUnit.SECONDS.toMillis(600000);

	public static final String NAMESPACE = "http://gcube-system.org/namespaces/opensearch/OpenSearchDataSource/service";
	public static final String NAME = "gcube/opensearch/opensearchdatasource/OpenSearchDataSource";
	public static final String FACTORYNAME = "gcube/opensearch/opensearchdatasource/OpenSearchDataSourceFactory";
	public static final QName name = new QName("http://gcube-system.org/namespaces/opensearch/OpenSearchDataSource/service", "OpenSearchDataSourceService");
	public static final QName factoryname = new QName("http://gcube-system.org/namespaces/opensearch/OpenSearchDataSourceFactory/service", "OpenSearchDataSourceFactoryService");
	public static final String porttypeNS = "http://gcube-system.org/namespaces/opensearch/OpenSearchDataSource";
	public static final String porttypeLN = "OpenSearchDataSourcePortType";
	public static final String factoryporttypeNS = "http://gcube-system.org/namespaces/opensearch/OpenSearchDataSourceFactory";
	public static final String factoryporttypeLN = "OpenSearchDataSourceFactoryPortType";
	
	public static final String gcubeClass = "OpenSearch";
	public static final String gcubeName = "OpenSearchDataSource";
	
	public static final GCoreService<OpenSearchDataSourceStub> osds = service().withName(name)
            .coordinates(gcubeClass,gcubeName)
                .andInterface(OpenSearchDataSourceStub.class); 

	public static final GCoreService<OpenSearchDataSourceFactoryStub> osdsf = service().withName(factoryname)
            .coordinates(gcubeClass,gcubeName)
                .andInterface(OpenSearchDataSourceFactoryStub.class);

}