/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.test.duplicategenerator;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.events.KeyValueEvent;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.sort.OfflineSortWorker;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.test.generators.Generator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateGeneratorWorker
extends Thread {
    private static Logger logger = LoggerFactory.getLogger((String)OfflineSortWorker.class.getName());
    private IRecordWriter<Record> writer = null;
    private int count = 0;
    private double duplicateProbability = 0.3f;
    private Integer seed = null;
    String[] fieldNames = null;
    String objIdFieldName = null;
    String objRankFieldName = null;
    private Generator<? extends Object>[] fieldGenerators;
    private boolean singleField = false;
    private boolean onlyFinalEvent = false;
    private int bufferCapacity;
    private File outFile = null;

    public DuplicateGeneratorWorker(IRecordWriter<Record> writer, int count, String[] fieldNames, String objIdFieldName, String objRankFieldName, Generator<? extends Object>[] fieldGenerators, boolean singleField, boolean onlyFinalEvent, double duplicateProbability, Integer seed, File outFile) throws Exception {
        this.count = count;
        this.duplicateProbability = duplicateProbability;
        this.fieldNames = fieldNames;
        this.objIdFieldName = objIdFieldName;
        this.objRankFieldName = objRankFieldName;
        this.fieldGenerators = fieldGenerators;
        this.singleField = singleField;
        this.onlyFinalEvent = onlyFinalEvent;
        this.seed = seed;
        this.writer = writer;
        this.outFile = outFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int objIdIndex = -1;
        int objRankIndex = -1;
        for (int i = 0; i < this.fieldNames.length; ++i) {
            if (this.fieldNames[i].equals(this.objIdFieldName)) {
                objIdIndex = i;
                continue;
            }
            if (!this.fieldNames[i].equals(this.objRankFieldName)) continue;
            objRankIndex = i;
        }
        BufferedWriter out = null;
        try {
            if (this.outFile != null) {
                try {
                    out = new BufferedWriter(new FileWriter(this.outFile));
                }
                catch (IOException e) {
                    logger.warn("Could not open output file", (Throwable)e);
                }
            }
            Random rnd = null;
            rnd = this.seed != null ? new Random(this.seed.intValue()) : new Random(Calendar.getInstance().getTimeInMillis());
            Integer rc = 0;
            int eventsEmitted = 0;
            boolean finalEmitted = false;
            long now = Calendar.getInstance().getTimeInMillis();
            HashMap storedRecs = new HashMap();
            while (rc < this.count) {
                Object dupFields;
                Integer n;
                Comparable<StringBuilder> outRecord;
                if (rc == 1) {
                    logger.info("Time to first input: " + (Calendar.getInstance().getTimeInMillis() - now));
                }
                String id = rc.toString();
                String collection = "TestCol";
                String rank = Double.valueOf(rnd.nextDouble()).toString();
                StringBuilder record = new StringBuilder();
                String objId = null;
                String objRank = null;
                record.append("<record>");
                Field[] fields = null;
                if (!this.singleField) {
                    fields = new Field[this.fieldGenerators.length];
                }
                for (int f = 0; f < this.fieldNames.length; ++f) {
                    String payload = this.fieldGenerators[f].next().toString();
                    if (!this.fieldNames[f].equals(this.objIdFieldName) && !this.fieldNames.equals(this.objRankFieldName)) {
                        record.append("<" + this.fieldNames[f] + ">");
                        record.append(payload);
                        record.append("</" + this.fieldNames[f] + ">");
                    }
                    if (this.fieldNames[f].equals(this.objIdFieldName)) {
                        objId = payload;
                    }
                    if (this.fieldNames[f].equals(this.objRankFieldName)) {
                        objRank = payload;
                    }
                    if (this.singleField) continue;
                    fields[f] = new StringField(payload);
                }
                if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
                    logger.info("Consumer side stopped consumption. Stopping prematurely");
                    System.out.println("Consumer side stopped consumption. Stopping prematurely");
                    break;
                }
                GenericRecord outRec = null;
                outRec = new GenericRecord();
                if (!this.singleField) {
                    outRec.setFields(fields);
                } else {
                    outRecord = new StringBuilder(record.toString());
                    outRec.setFields(new Field[]{new StringField(outRecord.append("<").append(this.objIdFieldName).append(">").append(objId).append("</").append(this.objIdFieldName).append(">").append("<").append(this.objRankFieldName).append(">").append(objRank).append("</").append(this.objRankFieldName).append(">").append("</record>").toString())});
                }
                if (!this.onlyFinalEvent || eventsEmitted < 10) {
                    if (rc % 100 == 0 && rc > 0) {
                        this.writer.emit((BufferEvent)new KeyValueEvent("resultsNumber", "" + rc));
                        ++eventsEmitted;
                    }
                } else if (!finalEmitted) {
                    this.writer.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", "" + this.count));
                    finalEmitted = true;
                }
                if (!this.writer.put((Record)outRec, 60L, TimeUnit.SECONDS)) {
                    if (this.writer.getStatus() == IBuffer.Status.Open) {
                        logger.warn("Could not write record " + rc + ". Skipping. Available Records = " + this.writer.availableRecords());
                        outRecord = rc;
                        n = rc = Integer.valueOf(rc + 1);
                        continue;
                    }
                    System.out.println("Consumer side stopped consumption. Random generator #" + id + " stopping prematurely");
                    break;
                }
                if (out != null) {
                    if (this.singleField) {
                        try {
                            out.write(((StringField)outRec.getField(0)).getPayload());
                            out.newLine();
                        }
                        catch (Exception e) {
                            logger.warn("Could not persist record to output file", (Throwable)e);
                        }
                    } else {
                        try {
                            for (int f = 0; f < this.fieldNames.length; ++f) {
                                out.write(((StringField)outRec.getField(f)).getPayload() + " ");
                            }
                            out.newLine();
                        }
                        catch (Exception e) {
                            logger.warn("Could not persist record to output file", (Throwable)e);
                        }
                    }
                }
                if (rc < 0) {
                    if (this.singleField) {
                        System.out.println(((StringField)outRec.getField(0)).getPayload());
                    } else {
                        for (int f = 0; f < this.fieldNames.length; ++f) {
                            if (!(outRec.getField(f) instanceof StringField)) continue;
                            System.out.print(((StringField)outRec.getField(f)).getPayload() + " ");
                        }
                        System.out.println();
                    }
                }
                if (rnd.nextDouble() < this.duplicateProbability + 0.1) {
                    storedRecs.put(rc, new ArrayList());
                    if (this.singleField) {
                        ((List)storedRecs.get(rc)).add(record.toString());
                        ((List)storedRecs.get(rc)).add(objRank);
                        ((List)storedRecs.get(rc)).add(objId);
                    } else {
                        for (int f = 0; f < this.fieldNames.length; ++f) {
                            if (!(outRec.getField(f) instanceof StringField)) continue;
                            ((List)storedRecs.get(rc)).add(((StringField)outRec.getField(f)).getPayload());
                        }
                    }
                }
                Integer f = rc;
                n = rc = Integer.valueOf(rc + 1);
                if (!(rnd.nextDouble() < this.duplicateProbability) || storedRecs.isEmpty()) continue;
                Integer dupID = null;
                List dupPayload = null;
                int pos = rnd.nextInt(storedRecs.size());
                int i = 0;
                for (Map.Entry e : storedRecs.entrySet()) {
                    if (i == pos) {
                        dupID = (Integer)e.getKey();
                        dupPayload = (List)e.getValue();
                        break;
                    }
                    ++i;
                }
                String dupRank = Double.valueOf(rnd.nextDouble()).toString();
                if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
                    logger.info("Consumer side stopped consumption. Stopping prematurely");
                    System.out.println("Consumer side stopped consumption. Stopping prematurely");
                    break;
                }
                GenericRecord dupRec = null;
                if (this.singleField) {
                    dupRec = new GenericRecord();
                    StringBuilder dupRecord = new StringBuilder((String)dupPayload.get(2));
                    dupRec.setFields(new Field[]{new StringField(dupRecord.append("<").append(this.objIdFieldName).append(">").append(dupID).append("</").append(this.objIdFieldName).append(">").append("<").append(this.objRankFieldName).append(">").append(dupRank).append("</").append(this.objRankFieldName).append(">").append("</record>").toString())});
                } else {
                    dupFields = new Field[this.fieldNames.length];
                    for (int f2 = 0; f2 < dupPayload.size(); ++f2) {
                        dupFields[f2] = !this.fieldNames[f2].equals(this.objRankFieldName) ? new StringField((String)dupPayload.get(f2)) : new StringField(dupRank);
                    }
                    dupRec = new GenericRecord();
                    dupRec.setFields(dupFields);
                }
                if (!this.writer.put((Record)dupRec, 60L, TimeUnit.SECONDS)) {
                    if (this.writer.getStatus() == IBuffer.Status.Open) {
                        logger.warn("Could not write record " + rc + ". Skipping. Available Records = " + this.writer.availableRecords());
                        dupFields = rc;
                        Integer n2 = rc = Integer.valueOf(rc + 1);
                        continue;
                    }
                    System.out.println("Consumer side stopped consumption. Random generator #" + id + " stopping prematurely");
                    break;
                }
                if (out == null) continue;
                try {
                    out.write("DUPLICATE:");
                    if (this.singleField) {
                        out.write(((StringField)dupRec.getField(0)).getPayload());
                    } else {
                        for (int f3 = 0; f3 < this.fieldNames.length; ++f3) {
                            if (!(dupRec.getField(f3) instanceof StringField)) continue;
                            out.write(((StringField)dupRec.getField(f3)).getPayload() + " ");
                        }
                    }
                    out.newLine();
                }
                catch (Exception e) {
                    logger.warn("Could not persist record to output file", (Throwable)e);
                }
            }
            logger.info("Data generation took " + (Calendar.getInstance().getTimeInMillis() - now));
            logger.info("Production rate was " + (float)rc.intValue() / (float)(Calendar.getInstance().getTimeInMillis() - now) * 1000.0f);
        }
        catch (Exception e) {
            logger.error("Error while generating duplicates", (Throwable)e);
        }
        finally {
            try {
                this.writer.close();
            }
            catch (Exception e) {}
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    logger.warn("Could not close output file", (Throwable)e);
                }
            }
        }
    }
}

