/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.test.filersgenerator;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IProxy;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.http.HTTPWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.FileField;
import gr.uoa.di.madgik.grs.record.field.FileFieldDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.sort.OfflineSortWorker;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.test.generators.FloatGenerator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.Calendar;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRSGeneratorWorker
extends Thread {
    private static Logger logger = LoggerFactory.getLogger((String)OfflineSortWorker.class.getName());
    private RecordWriter writer = null;
    private URI outLocator = null;
    private int count = 0;
    private int id;
    private long timeout;
    private TimeUnit timeUnit;
    private Float threshold;
    private String path = null;
    private File outFile = null;
    private Object synchWriter = null;

    public FileRSGeneratorWorker(String path, int id, IProxy.ProxyType proxyType, long timeout, TimeUnit timeUnit, Float threshold, File outFile, Object synchWriter) throws Exception {
        this.path = path;
        this.id = id;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.threshold = Float.valueOf(threshold != null ? threshold.floatValue() : RecordWriter.DefaultThreshold);
        this.outFile = outFile;
        if (this.threshold.floatValue() < 0.0f || this.threshold.floatValue() > 1.0f) {
            throw new Exception("Invalid threshold value");
        }
        LocalWriterProxy producerProxy = null;
        FileFieldDefinition fileFieldDef = new FileFieldDefinition();
        fileFieldDef.setTransportDirective(IBuffer.TransportDirective.Partial);
        RecordDefinition[] defs = new RecordDefinition[]{new GenericRecordDefinition(new FieldDefinition[]{fileFieldDef})};
        switch (proxyType) {
            case Local: {
                producerProxy = new LocalWriterProxy();
                break;
            }
            case TCP: {
                producerProxy = new TCPWriterProxy();
                break;
            }
            case HTTP: {
                producerProxy = new HTTPWriterProxy();
            }
        }
        if (threshold == null) {
            this.writer = new RecordWriter((IWriterProxy)producerProxy, defs, 100, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
        }
        this.outLocator = producerProxy.getLocator();
        this.synchWriter = synchWriter;
    }

    public URI getLocator() {
        return this.outLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName("FileRSGeneratorWorker #" + this.id);
        FloatGenerator fg = new FloatGenerator(null);
        int rc = 0;
        long now = Calendar.getInstance().getTimeInMillis();
        Random rnd = new Random(47L);
        BufferedWriter out = null;
        boolean thresholdRecs = false;
        Object thresholdSync = null;
        if (out != null) {
            try {
                out = new BufferedWriter(new FileWriter(this.outFile));
            }
            catch (IOException e) {
                logger.warn("Could not open output file", (Throwable)e);
            }
        }
        Object e = this.synchWriter;
        synchronized (e) {
            this.synchWriter.notify();
        }
        try {
            File dir = new File(this.path);
            File[] rsFiles = dir.listFiles();
            if (rsFiles == null) {
                logger.error("Error while listing directory files");
                return;
            }
            for (File f : rsFiles) {
                block23: {
                    if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
                        System.out.println("Consumer side stopped consumption. Random generator #" + this.id + " stopping prematurely");
                        break;
                    }
                    if (rc == 1) {
                        System.out.println("Time to first input: " + (Calendar.getInstance().getTimeInMillis() - now));
                    }
                    GenericRecord outRec = new GenericRecord();
                    FileField outField = new FileField(f);
                    outRec.setFields(new Field[]{outField});
                    try {
                        long startpout = System.currentTimeMillis();
                        try {
                            this.writer.put((Record)outRec);
                            break block23;
                        }
                        catch (GRS2WriterException e2) {
                            logger.warn("Could not write record " + rc + ". Skipping. Available Records = " + this.writer.availableRecords() + " time elapsed = " + (System.currentTimeMillis() - startpout));
                        }
                    }
                    catch (GRS2WriterException e3) {
                        logger.warn("Could not write record " + rc + ". Skipping. Available Records = " + this.writer.availableRecords(), (Throwable)e3);
                    }
                    catch (Exception e4) {
                        logger.warn("Could not write record " + rc + ". Skipping. Available Records = " + this.writer.availableRecords(), (Throwable)e4);
                    }
                    continue;
                }
                ++rc;
                if (out != null) {
                    try {
                        out.write(f.getPath());
                        out.newLine();
                    }
                    catch (Exception e5) {
                        logger.warn("Could not persist record to output file", (Throwable)e5);
                    }
                }
                if (rc == this.count) break;
            }
            this.writer.close();
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e6) {
                    logger.warn("Could nnot close output file", (Throwable)e6);
                }
            }
        }
        catch (GRS2WriterException e2) {
            logger.warn("Could not close writer");
        }
        long closestop = Calendar.getInstance().getTimeInMillis();
        logger.info("Data generation took " + (closestop - now));
        logger.info("Produced " + rc + " records");
        logger.info("Production rate was " + (float)rc / (float)(closestop - now) * 1000.0f);
    }
}

