/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.test.seqgenerator;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.events.KeyValueEvent;
import gr.uoa.di.madgik.grs.proxy.IProxy;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.http.HTTPWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.net.URI;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeqGeneratorWorker
extends Thread {
    private static Logger logger = LoggerFactory.getLogger((String)SeqGeneratorWorker.class.getName());
    private IRecordWriter<Record> writer = null;
    private URI outLocator = null;
    private int count = 0;
    private boolean RS = false;
    private boolean singleField = false;
    private long timeout = 0L;
    private TimeUnit timeUnit = null;
    private boolean noise = false;
    private int noiseField = 0;
    String[] fieldNames = null;
    int id;
    Integer seed = null;
    private Object synchWriter = null;

    public SeqGeneratorWorker(int count, boolean RS, IProxy.ProxyType proxyType, boolean singleField, boolean noise, int noiseField, String[] fieldNames, int id, Integer seed, long timeout, TimeUnit timeUnit, Object synchWriter) throws Exception {
        this.count = count;
        this.RS = RS;
        this.singleField = singleField;
        this.fieldNames = fieldNames;
        this.noise = noise;
        this.noiseField = noiseField;
        this.id = id;
        this.seed = seed;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        RecordDefinition[] defs = null;
        if (!this.singleField) {
            StringFieldDefinition[] fieldDefs = new StringFieldDefinition[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                fieldDefs[i] = new StringFieldDefinition(fieldNames[i]);
            }
            defs = new RecordDefinition[]{new GenericRecordDefinition((FieldDefinition[])fieldDefs)};
        } else {
            defs = new RecordDefinition[]{new GenericRecordDefinition(new FieldDefinition[]{new StringFieldDefinition()})};
        }
        LocalWriterProxy producerProxy = null;
        switch (proxyType) {
            case Local: {
                producerProxy = new LocalWriterProxy();
                break;
            }
            case TCP: {
                producerProxy = new TCPWriterProxy();
                break;
            }
            case HTTP: {
                producerProxy = new HTTPWriterProxy();
            }
        }
        this.writer = new RecordWriter((IWriterProxy)producerProxy, defs, 100, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
        this.outLocator = this.writer.getLocator();
        this.synchWriter = synchWriter;
    }

    public URI getLocator() {
        return this.outLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Random rnd = null;
        rnd = this.seed != null ? new Random(this.seed.intValue()) : new Random(Calendar.getInstance().getTimeInMillis());
        int rc = 0;
        long now = Calendar.getInstance().getTimeInMillis();
        Object object = this.synchWriter;
        synchronized (object) {
            this.synchWriter.notify();
        }
        int eventsEmitted = 0;
        boolean finalEmitted = false;
        try {
            while (rc < this.count) {
                if (rc == 1) {
                    logger.info("Time to first input: " + (Calendar.getInstance().getTimeInMillis() - now));
                }
                StringBuilder record = new StringBuilder();
                Hashtable attrs = new Hashtable();
                String docId = Integer.valueOf(this.id).toString() + ":" + Integer.valueOf(rc).toString();
                String colId = "TestCol";
                String rank = Float.valueOf(rnd.nextFloat()).toString();
                if (this.RS) {
                    record.append("<RSRecord ");
                    record.append("DocID=\"" + (String)attrs.get("DocID") + "\" ");
                    record.append("CollID=\"" + (String)attrs.get("CollID") + "\"");
                    record.append("\" RankID=\"" + (String)attrs.get("RankID"));
                    record.append("\">");
                } else {
                    record.append("<record>");
                }
                Field[] fields = null;
                if (!this.singleField) {
                    fields = new Field[this.fieldNames.length];
                }
                for (int f = 0; f < this.fieldNames.length; ++f) {
                    record.append("<" + this.fieldNames[f] + ">");
                    int rndLength = rnd.nextInt(50) + 1;
                    record.append(this.fieldNames[f]);
                    String payload = "";
                    payload = payload + this.fieldNames[f] + rc;
                    if (this.noise && f == this.noiseField && rnd.nextInt(100) > 60) {
                        payload = payload + "_" + rnd.nextInt(4000);
                    }
                    record.append(payload);
                    record.append("</" + this.fieldNames[f] + ">");
                    if (this.singleField) continue;
                    fields[f] = new StringField(payload);
                }
                if (!this.RS) {
                    record.append("</record>");
                }
                GenericRecord outRec = null;
                if (!this.singleField) {
                    outRec = new GenericRecord();
                    outRec.setFields(fields);
                } else {
                    outRec = new GenericRecord();
                    outRec.setFields(new Field[]{new StringField(record.toString())});
                }
                if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
                    logger.info("Consumer side stopped consumption. Sequence generator #" + this.id + " stopping prematurely");
                    System.out.println("Consumer side stopped consumption. Sequence generator #" + this.id + " stopping prematurely");
                    break;
                }
                if (eventsEmitted < 0) {
                    if (rc % 100 == 0 && rc > 0) {
                        this.writer.emit((BufferEvent)new KeyValueEvent("resultsNumber", "" + rc));
                        ++eventsEmitted;
                    }
                } else if (!finalEmitted) {
                    this.writer.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", "" + this.count));
                    finalEmitted = true;
                }
                if (!this.writer.put((Record)outRec, this.timeout, this.timeUnit)) {
                    if (this.writer.getStatus() == IBuffer.Status.Open) {
                        logger.warn("Could not write record " + rc + ". Skipping. Available Records = " + this.writer.availableRecords());
                        ++rc;
                        continue;
                    }
                    System.out.println("Consumer side stopped consumption. Sequence generator #" + this.id + " stopping prematurely");
                    break;
                }
                ++rc;
            }
            logger.info("Data generation took " + (Calendar.getInstance().getTimeInMillis() - now));
        }
        catch (Exception e) {
            logger.error("Error while generating sequence", (Throwable)e);
        }
        finally {
            try {
                this.writer.close();
            }
            catch (Exception e) {}
        }
    }
}

