/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.extjdbc;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class QueryParser {
    private static Logger logger = LoggerFactory.getLogger((String)QueryParser.class.getName());
    Document query = null;

    public QueryParser(String queryString) throws Exception {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.query = db.parse(new InputSource(new StringReader(queryString)));
        }
        catch (Exception e) {
            logger.error("Could not parse query. Throwing Exception", (Throwable)e);
            throw new Exception("Could not parse query");
        }
    }

    public String getQuery() throws Exception {
        Element docEle = this.query.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("query");
        if (nl == null || nl.getLength() != 1) {
            logger.error("Null or more than one query elements. Throwing Exception");
            throw new Exception("Null or more than one query elements");
        }
        return ((Element)nl.item(0)).getFirstChild().getNodeValue();
    }

    public String getDriverName() throws Exception {
        Element docEle = this.query.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("driverName");
        if (nl == null || nl.getLength() != 1) {
            logger.error("Null or more than one driverName elements. Throwing Exception");
            throw new Exception("Null or more than one driverName elements");
        }
        return ((Element)nl.item(0)).getFirstChild().getNodeValue();
    }

    public String getConnectionString() throws Exception {
        Element docEle = this.query.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("connectionString");
        if (nl == null || nl.getLength() != 1) {
            logger.error("Null or more than one connectionString elements. Throwing Exception");
            throw new Exception("Null or more than one connectionString elements");
        }
        return ((Element)nl.item(0)).getFirstChild().getNodeValue();
    }
}

