/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.keeptop;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.sort.OfflineSortWorker;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepTopWorker<T extends Record>
extends Thread {
    private static Logger logger = LoggerFactory.getLogger((String)OfflineSortWorker.class.getName());
    private IRecordWriter<T> writer = null;
    private int count = 0;
    private IRecordReader<T> reader = null;
    private StatsContainer stats = null;
    private long timeout;
    private TimeUnit timeUnit;

    public KeepTopWorker(IRecordReader<T> reader, IRecordWriter<T> writer, int count, StatsContainer stats, long timeout, TimeUnit timeUnit) {
        this.reader = reader;
        this.count = count;
        this.stats = stats;
        this.writer = writer;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    @Override
    public void run() {
        int rc = 0;
        long firststop = 0L;
        long start = Calendar.getInstance().getTimeInMillis();
        while (rc < this.count) {
            try {
                if (this.reader.getStatus() == IBuffer.Status.Dispose || this.reader.getStatus() == IBuffer.Status.Close && this.reader.availableRecords() == 0) break;
                Record rec = this.reader.get(this.timeout, this.timeUnit);
                if (rec == null) {
                    if (this.reader.getStatus() != IBuffer.Status.Open) break;
                    logger.warn("Producer has timed out");
                    break;
                }
                if (rc == 0) {
                    logger.info("Time to first input: " + (Calendar.getInstance().getTimeInMillis() - start));
                    this.stats.timeToFirstInput(Calendar.getInstance().getTimeInMillis() - start);
                }
                if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
                    logger.info("Consumer side stopped consumption. Stopping.");
                    break;
                }
                if (!this.writer.importRecord(rec, this.timeout, this.timeUnit)) {
                    if (this.writer.getStatus() != IBuffer.Status.Open) break;
                    logger.warn("Consumer has timed out");
                    break;
                }
                if (++rc != 1) continue;
                firststop = Calendar.getInstance().getTimeInMillis();
            }
            catch (Exception e) {
                logger.error("Could not retrieve the record. Continuing");
            }
        }
        try {
            this.reader.close();
            this.writer.close();
        }
        catch (Exception e) {
            logger.warn("Could not close reader or writer", (Throwable)e);
        }
        long closestop = Calendar.getInstance().getTimeInMillis();
        this.stats.timeToComplete(closestop - start);
        this.stats.timeToFirst(firststop - start);
        this.stats.producedResults(rc);
        this.stats.productionRate((float)rc / (float)(closestop - start) * 1000.0f);
        logger.info("KEEPTOP OPERATOR:Produced first result in " + (firststop - start) + " milliseconds\n" + "Produced last result in " + (closestop - start) + " milliseconds\n" + "Produced " + rc + " results\n" + "Production rate was " + (float)rc / (float)(closestop - start) * 1000.0f + " records per second");
    }
}

