/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.extjdbc;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.extjdbc.JdbcResultElement;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.net.URI;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryJdbcWorker
extends Thread {
    private static Logger logger = LoggerFactory.getLogger((String)QueryJdbcWorker.class.getName());
    private IRecordWriter<Record> writer = null;
    private URI outLocator = null;
    private ResultSet rs = null;
    private String[] columnNames = null;
    private String UniqueDocId = null;
    private StatsContainer stats;
    private long timeout;
    private TimeUnit timeUnit;

    public QueryJdbcWorker(ResultSet rs, String[] columnNames, String UniqueDocId, IRecordWriter<Record> writer, long timeout, TimeUnit timeUnit, StatsContainer stats) {
        this.rs = rs;
        this.columnNames = columnNames;
        this.UniqueDocId = UniqueDocId;
        this.stats = stats;
        this.writer = writer;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    public URI getLocator() {
        return this.outLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long start = Calendar.getInstance().getTimeInMillis();
        try {
            this.stats.timeToFirstInput(0L);
            long rowCounter = 0L;
            long firstInputStop = 0L;
            long firstOutputStop = 0L;
            while (this.rs.next()) {
                try {
                    if (rowCounter == 0L) {
                        firstInputStop = Calendar.getInstance().getTimeInMillis();
                    }
                    if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
                        logger.info("Consumer side stopped consumption. Stopping.");
                        break;
                    }
                    GenericRecord rec = new GenericRecord();
                    Field[] fields = new Field[]{new StringField(this.UniqueDocId + Long.toString(rowCounter)), new StringField(JdbcResultElement.rs2XML(this.columnNames, this.rs))};
                    rec.setFields(fields);
                    if (!this.writer.put((Record)rec, this.timeout, this.timeUnit)) {
                        if (this.writer.getStatus() != IBuffer.Status.Open) break;
                        logger.warn("Consumer has timed out");
                        break;
                    }
                    if (++rowCounter != 1L) continue;
                    firstOutputStop = Calendar.getInstance().getTimeInMillis();
                }
                catch (Exception e) {
                    logger.error("Could not add record. Continuing", (Throwable)e);
                }
            }
            long closestop = Calendar.getInstance().getTimeInMillis();
            this.stats.timeToComplete(closestop - start);
            this.stats.timeToFirstInput(firstInputStop - start);
            this.stats.timeToFirst(firstOutputStop - start);
            this.stats.producedResults(rowCounter);
            this.stats.productionRate((float)rowCounter / (float)(closestop - start) * 1000.0f);
            logger.info("JDBC OPERATOR:\nProduced first result in " + (firstOutputStop - start) + " milliseconds\n" + "Produced last result in " + (closestop - start) + " milliseconds\n" + "Production rate was " + (float)rowCounter / (float)(closestop - start) * 1000.0f + " records per second");
        }
        catch (Exception e) {
            logger.error("Error while background populating. Closing", (Throwable)e);
        }
        finally {
            try {
                this.writer.close();
            }
            catch (Exception exception) {}
        }
    }
}

