/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.transform;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformWorker<T extends Record>
extends Thread {
    private static Logger logger = LoggerFactory.getLogger((String)TransformWorker.class.getName());
    private IRecordWriter<Record> writer;
    private IRecordReader<T> reader = null;
    private String payloadFieldName = null;
    private String xslt = null;
    private StatsContainer stats = null;
    private long timeout;
    private TimeUnit timeUnit;

    public TransformWorker(IRecordReader<T> reader, IRecordWriter<Record> writer, String payloadFieldName, String xslt, StatsContainer stats, long timeout, TimeUnit timeUnit) {
        this.reader = reader;
        this.writer = writer;
        this.payloadFieldName = payloadFieldName;
        this.xslt = xslt;
        this.stats = stats;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long start;
        long firstOutputStop;
        long firstInputStop;
        int rc;
        block25: {
            rc = 0;
            firstInputStop = 0L;
            firstOutputStop = Calendar.getInstance().getTimeInMillis();
            start = Calendar.getInstance().getTimeInMillis();
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer tr = tf.newTransformer(new StreamSource(new ByteArrayInputStream(this.xslt.getBytes())));
                while (true) {
                    try {
                        while (this.reader.getStatus() != IBuffer.Status.Dispose) {
                            String payload;
                            Record rec;
                            block26: {
                                if (this.reader.getStatus() == IBuffer.Status.Close && this.reader.availableRecords() == 0) {
                                    break block25;
                                }
                                rec = this.reader.get(this.timeout, this.timeUnit);
                                if (rec == null) {
                                    if (this.reader.getStatus() == IBuffer.Status.Open) {
                                        logger.warn("Producer has timed out");
                                    }
                                    break block25;
                                }
                                if (rc == 0) {
                                    firstInputStop = Calendar.getInstance().getTimeInMillis();
                                }
                                if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
                                    logger.info("Consumer side stopped consumption. Stopping.");
                                    break block25;
                                }
                                payload = null;
                                try {
                                    Field key = rec.getField(this.payloadFieldName);
                                    if (!(key instanceof StringField)) break block26;
                                    payload = ((StringField)key).getPayload();
                                }
                                catch (Exception e) {
                                    logger.warn("Could not extract payload from record #" + rc + ". Continuing");
                                    continue;
                                }
                            }
                            String transformed = null;
                            if (payload != null) {
                                StringWriter strWriter = new StringWriter();
                                tr.transform(new StreamSource(new StringReader(payload)), new StreamResult(strWriter));
                                transformed = strWriter.toString();
                                ((StringField)rec.getField(this.payloadFieldName)).setPayload(transformed);
                            }
                            if (!this.writer.importRecord(rec, this.timeout, this.timeUnit)) {
                                if (this.writer.getStatus() == IBuffer.Status.Open) {
                                    logger.warn("Consumer has timed out");
                                }
                                break block25;
                            }
                            if (++rc != 1) continue;
                            firstOutputStop = Calendar.getInstance().getTimeInMillis();
                        }
                    }
                    catch (Exception e) {
                        logger.error("Could not process record. Continuing", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.error("Error during background transformation. Closing", (Throwable)e);
            }
            finally {
                try {
                    this.writer.close();
                    this.reader.close();
                }
                catch (Exception ee) {}
            }
        }
        long closestop = Calendar.getInstance().getTimeInMillis();
        this.stats.timeToComplete(closestop - start);
        this.stats.timeToFirstInput(firstInputStop - start);
        this.stats.timeToFirst(firstOutputStop - start);
        this.stats.producedResults(rc);
        this.stats.productionRate((float)rc / (float)(closestop - start) * 1000.0f);
        logger.info("TRANSFORM OPERATOR:Produced first result in " + (firstOutputStop - start) + " milliseconds\n" + "Produced last result in " + (closestop - start) + " milliseconds\n" + "Produced " + rc + " results\n" + "Production rate was " + (float)rc / (float)(closestop - start) * 1000.0f + " records per second");
    }
}

