package gr.uoa.di.madgik.searchlibrary.operatorlibrary.transform;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Iterator;

public class CommandExecutor {
	private Process proc;
	private String command;

	private InputStream sErr;
	private OutputStream sIn;
	private InputStream sOut;

	private BufferedReader br;

	public CommandExecutor(String command) {
		this.command = command;
	}

	public void execute() throws IOException, InterruptedException {
		proc = Runtime.getRuntime().exec(command);

		sErr = proc.getErrorStream();
		sIn = proc.getOutputStream();
		sOut = proc.getInputStream();

		br = new BufferedReader(new InputStreamReader(sOut));

		// new Thread() {
		// public void run() {
		// pipe(sOut, System.out);
		// }
		// }.start();
	}

	public void transform(String str) throws IOException {
		sIn.write(str.getBytes());
		sIn.flush();
	}

	public int waitFor() throws IOException, InterruptedException {
		return proc.waitFor();
	}
	
	public int exitValue() throws IllegalThreadStateException {
		return proc.exitValue();
	}

	public void finished() throws IOException {
		sIn.close();
	}

	public BufferedReader getBufferedReader() {
		return br;
	}

	public static void pipe(InputStream in, OutputStream out) {
		try {
			int i = -1;

			byte[] buf = new byte[1024];

			while ((i = in.read(buf)) != -1) {
				out.write(buf, 0, i);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static void main(String[] args) throws IOException, InterruptedException {
		final CommandExecutor exec = new CommandExecutor("python " + "/home/jgerbe/Desktop/script.py");
		exec.execute();

		new Thread() {
			public void run() {
				try {
					BufferedReader br = new BufferedReader(new FileReader("/home/jgerbe/Desktop/u.data"));
					String line;
					while ((line = br.readLine()) != null) {
						exec.transform(line + "\n");
					}
					br.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
				try {
					exec.finished();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}.start();

		BufferedReader br = exec.getBufferedReader();

		StringBuilder total = new StringBuilder();
		String line;
		int cnt = 0;
		while ((line = br.readLine()) != null) {
			total.append(line);
			System.out.println(line);
		}
		
		System.out.println(exec.waitFor());

	}
}
