/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.indexfuse;

import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.indexfuse.FilePosition;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskBuffer {
    private static Logger logger = LoggerFactory.getLogger((String)DiskBuffer.class.getName());
    private RandomAccessFile ptr = null;
    private String filename = null;
    public long wtime = 0L;
    public long rtime = 0L;

    public DiskBuffer(String filename, boolean flag) throws Exception {
        this.filename = filename;
        this.ptr = flag ? new RandomAccessFile(new File(filename), "rw") : new RandomAccessFile(new File(filename), "r");
    }

    public FilePosition persist(Record rec) throws Exception {
        try {
            long now = Calendar.getInstance().getTimeInMillis();
            long start = this.ptr.getFilePointer();
            this.ptr.writeUTF(rec.getClass().getName());
            rec.deflate((DataOutput)this.ptr);
            long end = this.ptr.getFilePointer();
            this.wtime += Calendar.getInstance().getTimeInMillis() - now;
            return new FilePosition(start, end);
        }
        catch (Exception e) {
            logger.error("Could not perist record. throwing Exception", (Throwable)e);
            throw new Exception("Could not perist record");
        }
    }

    public void close() throws Exception {
        try {
            this.ptr.close();
            this.ptr = null;
        }
        catch (Exception e) {
            logger.error("Could not close buffer file. Throwing Exception", (Throwable)e);
            throw new Exception("Could not close buffer file");
        }
    }

    public Vector<Record> retrieve(Vector<FilePosition> pos) throws Exception {
        Vector<Record> res = new Vector<Record>();
        for (int i = 0; i < pos.size(); ++i) {
            try {
                res.add(this.retrieve(pos.get(i)));
                continue;
            }
            catch (Exception e) {
                logger.error("Could not retrieve position.Continuing", (Throwable)e);
            }
        }
        return res;
    }

    public Record retrieve(FilePosition pos) throws Exception {
        try {
            long now = Calendar.getInstance().getTimeInMillis();
            this.ptr.seek(pos.getStartOffset());
            Record rec = (Record)Class.forName(this.ptr.readUTF()).newInstance();
            rec.inflate((DataInput)this.ptr);
            this.rtime += Calendar.getInstance().getTimeInMillis() - now;
            return rec;
        }
        catch (Exception e) {
            logger.error("Could not retrieve record. throwing Exception", (Throwable)e);
            throw new Exception("Could not retrieve record");
        }
    }

    public void clear() {
        try {
            if (this.ptr != null) {
                this.ptr.close();
            }
            if (this.filename != null) {
                new File(this.filename).delete();
            }
        }
        catch (Exception e) {
            logger.error("Could not clear internal structures. Continuing", (Throwable)e);
        }
    }
}

