/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary;

import gr.uoa.di.madgik.searchlibrary.operatorlibrary.Unary;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnaryOp {
    private Logger log = LoggerFactory.getLogger((String)UnaryOp.class.getName());
    private static final Class<?>[] operatorConstructorParameterTypes = new Class[]{URI.class, Map.class, StatsContainer.class};
    private static final Class<?>[] operatorConstructorParameterTypes2 = new Class[]{URI.class, Map.class, StatsContainer.class, Long.class, TimeUnit.class};
    private Unary unaryOpeator;

    public UnaryOp(String operatorType, URI inLocator, Map<String, String> operatorParameters, StatsContainer stats) throws Exception {
        Class<?> UnaryClass = Class.forName(operatorType);
        if (UnaryClass == null) {
            this.log.error("Could not find opearator with " + operatorType + " operatorType.");
            throw new Exception("Could not find operator with operatorType " + operatorType);
        }
        try {
            Constructor<?> operatorConstructor = UnaryClass.getConstructor(operatorConstructorParameterTypes);
            this.unaryOpeator = (Unary)operatorConstructor.newInstance(inLocator, operatorParameters, stats);
        }
        catch (Exception e) {
            this.log.error("Error when instanciating the data source.", (Throwable)e);
            throw new Exception("Error when instanciating the data source", e);
        }
    }

    public UnaryOp(String operatorType, URI inLocator, HashMap<String, String> operatorParameters, StatsContainer stats) throws Exception {
        this(operatorType, inLocator, (Map<String, String>)operatorParameters, stats);
    }

    public UnaryOp(String operatorType, URI inLocator, Map<String, String> operatorParameters, StatsContainer stats, long timeout, TimeUnit timeUnit) throws Exception {
        Class<?> UnaryClass = Class.forName(operatorType);
        if (UnaryClass == null) {
            this.log.error("Could not find opearator with " + operatorType + " operatorType.");
            throw new Exception("Could not find operator with operatorType " + operatorType);
        }
        try {
            Constructor<?> operatorConstructor = UnaryClass.getConstructor(operatorConstructorParameterTypes2);
            this.unaryOpeator = (Unary)operatorConstructor.newInstance(new Object[]{inLocator, operatorParameters, timeout, timeUnit, stats});
        }
        catch (Exception e) {
            this.log.error("Error when instanciating the data source.", (Throwable)e);
            throw new Exception("Error when instanciating the data source", e);
        }
    }

    public UnaryOp(String operatorType, URI inLocator, HashMap<String, String> operatorParameters, StatsContainer stats, long timeout, TimeUnit timeUnit) throws Exception {
        this(operatorType, inLocator, (Map<String, String>)operatorParameters, stats, timeout, timeUnit);
    }

    public URI compute() throws Exception {
        return this.unaryOpeator.compute();
    }
}

