/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.partition;

import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.Unary;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.partition.PartitionWorker;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.net.URI;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionOp
extends Unary {
    private Logger logger = LoggerFactory.getLogger((String)PartitionOp.class.getName());
    private String clusterBy = null;
    private static final String outputFieldName = "locator";

    public PartitionOp(URI inLocator, Map<String, String> operatorParameters, StatsContainer stats) throws Exception {
        super(inLocator, operatorParameters, stats);
        this.clusterBy = operatorParameters.get("clusterBy");
        if (this.clusterBy == null) {
            throw new Exception("partition fields unspecified");
        }
    }

    public PartitionOp(URI inLocator, Map<String, String> operatorParameters, StatsContainer stats, long timeout, TimeUnit timeUnit) throws Exception {
        super(inLocator, operatorParameters, stats, timeout, timeUnit);
        this.clusterBy = operatorParameters.get("clusterBy");
        if (this.clusterBy == null) {
            throw new Exception("partition fields unspecified");
        }
    }

    @Override
    public URI compute() throws Exception {
        try {
            long start = Calendar.getInstance().getTimeInMillis();
            ForwardReader reader = new ForwardReader(this.inLocator);
            int fieldIndex = this.clusterBy.matches("\\d*") && Integer.parseInt(this.clusterBy) < reader.getRecordDefinitions()[0].getDefinitionSize() ? Integer.parseInt(this.clusterBy) : reader.getRecordDefinitions()[0].getDefinition(this.clusterBy);
            RecordDefinition[] defs = new RecordDefinition[]{new GenericRecordDefinition(new FieldDefinition[]{new StringFieldDefinition(outputFieldName)})};
            RecordWriter writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), defs);
            PartitionWorker worker = new PartitionWorker(reader, (IRecordWriter<Record>)writer, fieldIndex, this.stats, this.timeout, this.timeUnit);
            worker.start();
            this.stats.timeToInitialize(Calendar.getInstance().getTimeInMillis() - start);
            return writer.getLocator();
        }
        catch (Exception e) {
            this.logger.error("Could not initialize selection operation. Throwing Exception", (Throwable)e);
            throw new Exception("Could not initialize selection operation");
        }
    }
}

