/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.select;

import gr.uoa.di.madgik.searchlibrary.operatorlibrary.select.Evaluator;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Binder {
    private String expr;
    private Set<String> refs;
    private Matcher m;
    private static final String DEFAULTPATTERN = "\\[(\\d+)\\]";

    public Binder(String expr) {
        this(expr, DEFAULTPATTERN);
    }

    public Binder(String expr, String pattern) {
        this.expr = expr;
        this.m = Pattern.compile(pattern + "(?=([^\"']*[\"'][^\"']*[\"'])*[^\"']*$)").matcher(expr);
        this.refs = new HashSet<String>();
        while (this.m.find()) {
            this.refs.add(this.m.group(1));
        }
    }

    public Set<String> getSubstitutions() {
        return this.refs;
    }

    public String substitute(Map<String, String> bindings) {
        this.m.reset(this.expr);
        String fin = this.expr;
        while (this.m.find()) {
            String ref = this.m.group(1);
            String repl = bindings.get(ref);
            fin = this.m.replaceFirst('\"' + repl + '\"');
            this.m.reset(fin);
        }
        return fin;
    }

    public static void main(String[] args) throws IOException {
        String expr = "[0] == '[666]' && [2] > 0 || [5] != \"[666]\"";
        Binder eval = new Binder(expr);
        System.out.println(expr);
        System.out.println(eval.getSubstitutions());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("0", "666");
        map.put("2", "1");
        map.put("5", "xa");
        System.out.println(map);
        String logical = eval.substitute(map);
        System.out.println(logical);
        try {
            System.out.println(Evaluator.jsEvaluator(logical));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

