/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.transform;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.transform.CommandExecutor;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptWorker<T extends Record>
extends Thread {
    private static Logger logger = LoggerFactory.getLogger((String)ScriptWorker.class.getName());
    private IRecordWriter<Record> writer;
    private IRecordReader<T> reader = null;
    private String script = null;
    private String schema = null;
    private CommandExecutor transformer;
    private StatsContainer stats = null;
    private long timeout;
    private TimeUnit timeUnit;
    private CountDownLatch latch = new CountDownLatch(1);

    public ScriptWorker(IRecordReader<T> reader, String script, String schema, StatsContainer stats, long timeout, TimeUnit timeUnit) throws Exception {
        this.reader = reader;
        this.script = script;
        this.schema = schema;
        this.stats = stats;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.transformer = new CommandExecutor(script);
        this.transformer.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long start;
        long firstOutputStop;
        long firstInputStop;
        int rc;
        block24: {
            rc = 0;
            firstInputStop = 0L;
            firstOutputStop = Calendar.getInstance().getTimeInMillis();
            start = Calendar.getInstance().getTimeInMillis();
            new Thread(){

                @Override
                public void run() {
                    int rc = 0;
                    block10: while (true) {
                        try {
                            while (ScriptWorker.this.reader.getStatus() != IBuffer.Status.Dispose && (ScriptWorker.this.reader.getStatus() != IBuffer.Status.Close || ScriptWorker.this.reader.availableRecords() != 0)) {
                                String payload;
                                Record rec = ScriptWorker.this.reader.get(ScriptWorker.this.timeout, ScriptWorker.this.timeUnit);
                                if (rec == null) {
                                    if (ScriptWorker.this.reader.getStatus() != IBuffer.Status.Open) break block10;
                                    logger.warn("Producer has timed out");
                                    break block10;
                                }
                                StringBuilder sbuilder = new StringBuilder();
                                try {
                                    for (Field key : rec.getFields()) {
                                        if (!(key instanceof StringField)) continue;
                                        sbuilder.append(((StringField)key).getPayload() + "\t");
                                    }
                                    if (sbuilder.length() > 0) {
                                        sbuilder.deleteCharAt(sbuilder.length() - 1);
                                    }
                                    sbuilder.append("\n");
                                    payload = sbuilder.toString();
                                }
                                catch (Exception e) {
                                    logger.warn("Could not extract payload from record #" + rc + ". Continuing");
                                    continue;
                                }
                                if (payload != null) {
                                    try {
                                        ScriptWorker.this.transformer.transform(payload);
                                    }
                                    catch (IOException e) {
                                        logger.error("Could not make transformation. returned code: " + ScriptWorker.this.transformer.exitValue());
                                        try {
                                            ScriptWorker.this.reader.close();
                                            ScriptWorker.this.writer.close();
                                        }
                                        catch (Exception e1) {
                                            // empty catch block
                                        }
                                    }
                                }
                                ++rc;
                            }
                        }
                        catch (Exception e) {
                            logger.warn("Could not extract payload from record #" + rc + ". Continuing", (Throwable)e);
                            continue;
                        }
                        break;
                    }
                    try {
                        ScriptWorker.this.transformer.finished();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }.start();
            try {
                BufferedReader br = this.transformer.getBufferedReader();
                while (true) {
                    try {
                        while (true) {
                            if (rc == 0) {
                                firstInputStop = Calendar.getInstance().getTimeInMillis();
                            }
                            if (this.writer != null && (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose)) {
                                logger.info("Consumer side stopped consumption. Stopping.");
                                break block24;
                            }
                            GenericRecord rec = new GenericRecord();
                            ArrayList<StringField> fieldList = new ArrayList<StringField>();
                            String line = br.readLine();
                            if (line == null) break block24;
                            for (String tok : line.split("\t")) {
                                fieldList.add(new StringField(tok));
                            }
                            rec.setFields(fieldList.toArray(new Field[fieldList.size()]));
                            if (this.writer == null) {
                                ArrayList<StringFieldDefinition> fieldDefs = new ArrayList<StringFieldDefinition>();
                                for (int i = 0; i < rec.getFields().length; ++i) {
                                    String fieldName = null;
                                    try {
                                        fieldName = this.schema.substring(1, this.schema.length() - 1).split(",")[i].trim();
                                    }
                                    catch (Exception e) {
                                        fieldName = Integer.toString(i);
                                    }
                                    fieldDefs.add(new StringFieldDefinition(fieldName));
                                }
                                FieldDefinition[] fieldDefsArray = fieldDefs.toArray(new FieldDefinition[fieldDefs.size()]);
                                this.writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), new RecordDefinition[]{new GenericRecordDefinition(fieldDefsArray)}, RecordWriter.DefaultBufferCapacity, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor, this.timeout, this.timeUnit);
                                this.latch.countDown();
                            }
                            if (!this.writer.importRecord((Record)rec, this.timeout, this.timeUnit)) {
                                if (this.writer.getStatus() == IBuffer.Status.Open) {
                                    logger.warn("Consumer has timed out");
                                }
                                break block24;
                            }
                            if (++rc != 1) continue;
                            firstOutputStop = Calendar.getInstance().getTimeInMillis();
                        }
                    }
                    catch (Exception e) {
                        logger.error("Could not process record. Continuing", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.error("Error during background transformation. Closing", (Throwable)e);
            }
            finally {
                try {
                    this.writer.close();
                    this.reader.close();
                }
                catch (Exception ee) {}
            }
        }
        long closestop = Calendar.getInstance().getTimeInMillis();
        this.stats.timeToComplete(closestop - start);
        this.stats.timeToFirstInput(firstInputStop - start);
        this.stats.timeToFirst(firstOutputStop - start);
        this.stats.producedResults(rc);
        this.stats.productionRate((float)rc / (float)(closestop - start) * 1000.0f);
        logger.info("SCRIPT OPERATOR:Produced first result in " + (firstOutputStop - start) + " milliseconds\n" + "Produced last result in " + (closestop - start) + " milliseconds\n" + "Produced " + rc + " results\n" + "Production rate was " + (float)rc / (float)(closestop - start) * 1000.0f + " records per second");
    }

    protected URI getLocator() throws InterruptedException, GRS2WriterException {
        this.latch.await();
        return this.writer.getLocator();
    }
}

