/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge;

import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.reader.decorators.keepalive.KeepAliveReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.OperationMode;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.ReaderHolder;
import java.net.URI;
import java.util.Calendar;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderInit
extends Thread {
    private Logger logger = LoggerFactory.getLogger((String)ReaderInit.class.getName());
    private Vector<ReaderHolder> readers = null;
    private int index = 0;
    private URI locator = null;
    private int bufferCapacity = -1;
    private String uid = null;
    private OperationMode multiplexPolicy;

    public ReaderInit(Vector<ReaderHolder> readers, int index, URI locator, OperationMode multiplexPolicy, int bufferCapacity, String uid) {
        this.readers = readers;
        this.index = index;
        this.locator = locator;
        this.multiplexPolicy = multiplexPolicy;
        this.bufferCapacity = bufferCapacity;
        this.uid = uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.setName("Reader Init #" + this.index);
            long initstart = Calendar.getInstance().getTimeInMillis();
            this.logger.trace(this.uid + ": Initializing reader #" + this.index + " with locator " + this.locator);
            ForwardReader reader = new ForwardReader(this.locator, this.bufferCapacity);
            if (this.multiplexPolicy == OperationMode.FIFO) {
                reader = new KeepAliveReader((IRecordReader)reader, 30L, TimeUnit.SECONDS);
            }
            this.readers.get(this.index).setReader((IRecordReader<Record>)reader);
            long initstop = Calendar.getInstance().getTimeInMillis();
            this.logger.info("MERGE OPERATOR " + this.uid + " THREAD INIT TOOK " + (initstop - initstart));
        }
        catch (Exception e) {
            this.logger.error("Could not initialize reader #" + this.index + " of operation " + this.uid + ". setting null", (Throwable)e);
            this.readers.get(this.index).setReader(null);
        }
        finally {
            Vector<ReaderHolder> vector = this.readers;
            synchronized (vector) {
                Object synchReader;
                this.readers.get(this.index).setWaitingForInit(false);
                Object object = synchReader = this.readers.get(this.index).getSynchReader();
                synchronized (object) {
                    synchReader.notify();
                }
            }
        }
    }
}

