/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.partition;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.partition.Partitioner;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionWorker<T extends Record>
extends Thread {
    private static Logger logger = LoggerFactory.getLogger((String)PartitionWorker.class.getName());
    private IRecordWriter<Record> writer = null;
    private IRecordReader<T> reader = null;
    private boolean byColumn;
    private int partitionField;
    private StatsContainer stats = null;
    private long timeout;
    private TimeUnit timeUnit;

    public PartitionWorker(IRecordReader<T> reader, IRecordWriter<Record> writer, boolean byColumn, int partitionField, StatsContainer stats, long timeout, TimeUnit timeUnit) {
        this.reader = reader;
        this.writer = writer;
        this.byColumn = byColumn;
        this.partitionField = partitionField;
        this.stats = stats;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int rc;
        long firstOutputStop;
        long firstInputStop;
        long start;
        block25: {
            Thread.currentThread().setName(PartitionWorker.class.getName());
            start = Calendar.getInstance().getTimeInMillis();
            firstInputStop = 0L;
            firstOutputStop = start;
            rc = 0;
            int ln = 0;
            Partitioner partitioner = null;
            try {
                partitioner = new Partitioner(this.writer, this.reader.getRecordDefinitions(), this.timeout, this.timeUnit);
                int ro = 0;
                while (true) {
                    try {
                        while (this.reader.getStatus() != IBuffer.Status.Dispose) {
                            IRecordWriter<Record> rami;
                            String fieldValue;
                            Record rec;
                            block26: {
                                if (this.reader.getStatus() == IBuffer.Status.Close && this.reader.availableRecords() == 0) {
                                    break block25;
                                }
                                rec = this.reader.get(this.timeout, this.timeUnit);
                                if (rec == null) {
                                    if (this.reader.getStatus() == IBuffer.Status.Open) {
                                        logger.warn("Producer has timed out");
                                    }
                                    if (this.writer.getStatus() != IBuffer.Status.Close && this.writer.getStatus() != IBuffer.Status.Dispose) continue;
                                    logger.info("Producer has been closed.");
                                    break block25;
                                }
                                if (rc == 0) {
                                    firstInputStop = Calendar.getInstance().getTimeInMillis();
                                }
                                if (this.byColumn) {
                                    try {
                                        Field key = rec.getField(this.partitionField);
                                        if (!(key instanceof StringField)) {
                                            throw new Exception("Refence: " + key.getFieldDefinition().getName() + " is not a String field");
                                        }
                                        fieldValue = ((StringField)key).getPayload();
                                        break block26;
                                    }
                                    catch (Exception e) {
                                        logger.warn("Could not extract payload from record #" + ln++ + ". Continuing");
                                        continue;
                                    }
                                }
                                fieldValue = String.valueOf(ro++ % this.partitionField);
                            }
                            if (!(rami = partitioner.getWriter(fieldValue)).importRecord(rec, this.timeout, this.timeUnit)) {
                                if (rami.getStatus() == IBuffer.Status.Open) {
                                    logger.warn("Consumer has timed out");
                                }
                                break block25;
                            }
                            if (++rc != 1) continue;
                            firstOutputStop = Calendar.getInstance().getTimeInMillis();
                        }
                    }
                    catch (Exception e) {
                        logger.error("Could not retrieve the record. Continuing", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.error("Error during partitioning process. Closing", (Throwable)e);
            }
            finally {
                try {
                    partitioner.closeAll();
                    this.writer.close();
                    this.reader.close();
                }
                catch (Exception e) {}
            }
        }
        long closeStop = Calendar.getInstance().getTimeInMillis();
        this.stats.timeToComplete(closeStop - start);
        this.stats.timeToFirstInput(firstInputStop - start);
        this.stats.timeToFirst(firstOutputStop - start);
        this.stats.producedResults(rc);
        this.stats.productionRate((float)rc / (float)(closeStop - start) * 1000.0f);
        logger.info("PARTITION OPERATOR:Produced first result in " + (firstOutputStop - start) + " milliseconds\n" + "Produced last result in " + (closeStop - start) + " milliseconds\n" + "Produced " + rc + " results\n" + "Production rate was " + (float)rc / (float)(closeStop - start) * 1000.0f + " records per second");
    }
}

