/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.booleancompare;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.booleancompare.Compute;
import java.io.StringReader;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ComputeAverage
implements Compute {
    private static Logger logger = LoggerFactory.getLogger((String)ComputeAverage.class.getName());
    private String xpath;
    private String fieldName;
    private IRecordReader<Record> reader;
    private long timeout;
    private TimeUnit timeUnit;

    public ComputeAverage(String xpath, String fieldName, IRecordReader<Record> reader, long timeout, TimeUnit timeUnit) {
        this.xpath = xpath;
        this.fieldName = fieldName;
        this.reader = reader;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object compute() throws Exception {
        double AVERAGE = 0.0;
        long CNT = 0L;
        XPathExpression xpe = null;
        if (this.xpath != null) {
            XPathFactory xpf = XPathFactory.newInstance();
            XPath xp = xpf.newXPath();
            xpe = xp.compile("//" + this.xpath + " | //@" + this.xpath);
        }
        try {
            while (true) {
                Record rec;
                if ((rec = this.reader.get(this.timeout, this.timeUnit)) == null) {
                    if (this.reader.getStatus() != IBuffer.Status.Open) break;
                    logger.warn("Producer has timed out");
                    break;
                }
                StringField field = (StringField)rec.getField(this.fieldName);
                if (this.xpath != null) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setNamespaceAware(false);
                    factory.setIgnoringElementContentWhitespace(true);
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.parse(new InputSource(new StringReader(field.getPayload())));
                    NodeList myNodeList = (NodeList)xpe.evaluate(document.getDocumentElement(), XPathConstants.NODESET);
                    if (myNodeList.getLength() <= 0) continue;
                    if (!ComputeAverage.isNumeric(myNodeList.item(0).getFirstChild().getNodeValue())) {
                        throw new Exception("Node value is NOT numeric. Unable to calculate average of non-numerics");
                    }
                    for (int i = 0; i < myNodeList.getLength(); ++i) {
                        if (myNodeList.item(i).getChildNodes() == null || myNodeList.item(i).getChildNodes().getLength() == 0) continue;
                        AVERAGE += Double.parseDouble(myNodeList.item(i).getFirstChild().getNodeValue());
                    }
                    CNT += (long)myNodeList.getLength();
                    continue;
                }
                AVERAGE += Double.parseDouble(field.getPayload());
                ++CNT;
            }
        }
        catch (Exception e) {
            logger.error("could not complete compute", (Throwable)e);
            Object var7_7 = null;
            return var7_7;
        }
        finally {
            try {
                this.reader.close();
            }
            catch (Exception exception) {}
        }
        return new Double(AVERAGE /= (double)CNT).toString();
    }

    private static boolean isNumeric(String alphanum) {
        int i = 0;
        boolean dotFound = false;
        boolean isNumeric = true;
        for (i = 0; i < alphanum.length(); ++i) {
            if (Character.isDigit(alphanum.charAt(i))) continue;
            if (new Character(alphanum.charAt(i)).compareTo(new Character('.')) == 0 && !dotFound) {
                dotFound = true;
                continue;
            }
            isNumeric = false;
            break;
        }
        return isNumeric;
    }
}

