/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.except;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.util.Calendar;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptWorker
extends Thread {
    private static Logger logger = LoggerFactory.getLogger((String)ExceptWorker.class.getName());
    private IRecordReader<Record> leftReader = null;
    private IRecordReader<Record> rightReader = null;
    private String leftKeyFieldName = null;
    private String rightKeyFieldName = null;
    private IRecordWriter<Record> writer = null;
    private long timeout;
    private TimeUnit timeUnit = null;
    private int count = 0;
    private long firststop = 0L;
    private StatsContainer stats;

    public ExceptWorker(IRecordWriter<Record> writer, IRecordReader<Record> leftReader, IRecordReader<Record> rightReader, String leftKeyFieldName, String rightKeyFieldName, long timeout, TimeUnit timeUnit, StatsContainer stats) {
        this.leftReader = leftReader;
        this.rightReader = rightReader;
        this.leftKeyFieldName = leftKeyFieldName;
        this.rightKeyFieldName = rightKeyFieldName;
        this.writer = writer;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.stats = stats;
    }

    @Override
    public void run() {
        long start = Calendar.getInstance().getTimeInMillis();
        try {
            StringField keyField;
            Record record;
            HashSet<String> exceptSet = new HashSet<String>();
            block18: while (true) {
                try {
                    while (true) {
                        record = null;
                        if (this.rightReader.getStatus() == IBuffer.Status.Dispose || this.rightReader.getStatus() == IBuffer.Status.Close && this.rightReader.availableRecords() == 0) break block18;
                        record = this.rightReader.get(this.timeout, this.timeUnit);
                        if (record == null) {
                            if (this.rightReader.getStatus() != IBuffer.Status.Open) break block18;
                            logger.warn("Producer has timed out");
                            break block18;
                        }
                        keyField = null;
                        try {
                            keyField = (StringField)record.getField(this.rightKeyFieldName);
                        }
                        catch (Exception e) {
                            logger.warn("Could not extract value from record ", (Throwable)e);
                        }
                        if (keyField == null) continue;
                        exceptSet.add(keyField.getPayload());
                    }
                }
                catch (Exception e) {
                    logger.error("Could not retrieve the record. Continuing", (Throwable)e);
                    continue;
                }
                break;
            }
            block20: while (true) {
                try {
                    while (true) {
                        record = null;
                        if (this.leftReader.getStatus() == IBuffer.Status.Dispose || this.leftReader.getStatus() == IBuffer.Status.Close && this.leftReader.availableRecords() == 0) break block20;
                        record = this.leftReader.get(this.timeout, this.timeUnit);
                        if (record == null) {
                            if (this.leftReader.getStatus() != IBuffer.Status.Open) break block20;
                            logger.warn("Producer has timed out");
                            break block20;
                        }
                        keyField = null;
                        try {
                            keyField = (StringField)record.getField(this.leftKeyFieldName);
                        }
                        catch (Exception e) {
                            logger.warn("Could not extract value from record ", (Throwable)e);
                        }
                        if (keyField != null && exceptSet.contains(keyField.getPayload())) continue;
                        if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
                            logger.info("Consumer side stopped consumption. Stopping.");
                            break block20;
                        }
                        if (!this.writer.importRecord(record, this.timeout, this.timeUnit)) {
                            if (this.writer.getStatus() != IBuffer.Status.Open) break block20;
                            logger.warn("Consumer has timed out");
                            break block20;
                        }
                        ++this.count;
                    }
                }
                catch (Exception e) {
                    logger.error("Could not retrieve the record. Continuing", (Throwable)e);
                    continue;
                }
                break;
            }
            try {
                this.writer.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.leftReader.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.rightReader.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            long closestop = Calendar.getInstance().getTimeInMillis();
            logger.info("EXCEPT OPERATOR:");
            logger.info("Time to Complete: " + (closestop - start));
            logger.info("Time to First: " + (this.firststop - start));
            logger.info("Production Rate: " + (float)this.count / (float)(closestop - start) * 1000.0f + " records per second");
            logger.info("Produced Results: " + this.count);
            this.stats.timeToComplete(closestop - start);
            this.stats.timeToFirst(this.firststop - start);
            this.stats.productionRate((float)this.count / (float)(closestop - start) * 1000.0f);
            this.stats.producedResults(this.count);
        }
        catch (Exception e) {
            logger.error("Error while background joining. Closing", (Throwable)e);
            try {
                this.writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

