/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.gmerge;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradualWriterHolder {
    private Logger log = LoggerFactory.getLogger((String)GradualWriterHolder.class.getName());
    private RecordWriter<GenericRecord> writer;
    private static final String fieldName = "Locator";

    public GradualWriterHolder() throws Exception {
        RecordDefinition[] defs = new RecordDefinition[]{new GenericRecordDefinition(new FieldDefinition[]{new StringFieldDefinition(fieldName)})};
        this.writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), defs);
    }

    public URI getLocator() {
        try {
            return this.writer.getLocator();
        }
        catch (GRS2WriterException e) {
            return null;
        }
    }

    public void put(String uri) throws Exception {
        if (this.writer.getStatus() != IBuffer.Status.Open) {
            throw new Exception("Merger's resultSet has closed unexpectendly.");
        }
        GenericRecord rec = new GenericRecord();
        rec.setFields(new Field[]{new StringField(uri)});
        try {
            if (!this.writer.put((Record)rec, 60L, TimeUnit.SECONDS)) {
                throw new GRS2WriterException("Buffer capacity reached");
            }
        }
        catch (GRS2WriterException e) {
            this.log.warn("Could not add a subplan to merger");
        }
        this.log.info("Subplan Succesfully added to merger");
    }

    public void close() throws Exception {
        this.writer.close();
    }
}

