/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.rswriter;

import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementGC;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementType;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementWellFormed;
import org.gcube.common.searchservice.searchlibrary.resultset.helpers.RSConstants;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.ForceProductionTask;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool.RSPoolObject;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSFullWriter;

public class RSTEXTWriter
extends RSPoolObject {
    private static Logger log = Logger.getLogger(RSTEXTWriter.class);
    private Object synchAddition = null;
    private RSFullWriter writer = null;
    private int recsPerCount = 20;
    private int partSize = 102400;
    private Vector<String> records = null;
    private int size = 0;
    private Timer timer = null;
    private ForceProductionTask task = null;
    private boolean wellformed = true;

    public static RSTEXTWriter getRSTEXTWriter(boolean wellformed) throws Exception {
        try {
            PropertyElementWellFormed wf = null;
            wf = wellformed ? new PropertyElementWellFormed(PropertyElementWellFormed.YES) : new PropertyElementWellFormed(PropertyElementWellFormed.NO);
            return new RSTEXTWriter(RSFullWriter.getRSFullWriter(new PropertyElementBase[]{new PropertyElementGC(PropertyElementGC.unspecified), new PropertyElementType(PropertyElementType.TEXT), wf}), wellformed);
        }
        catch (Exception e) {
            log.error((Object)"could not create RSTEXTWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSTEXTWriter");
        }
    }

    public static RSTEXTWriter getRSTEXTWriter(boolean wellformed, boolean dataFlow) throws Exception {
        try {
            PropertyElementWellFormed wf = null;
            wf = wellformed ? new PropertyElementWellFormed(PropertyElementWellFormed.YES) : new PropertyElementWellFormed(PropertyElementWellFormed.NO);
            return new RSTEXTWriter(RSFullWriter.getRSFullWriter(new PropertyElementBase[]{new PropertyElementGC(PropertyElementGC.unspecified), new PropertyElementType(PropertyElementType.TEXT), wf}, dataFlow), wellformed);
        }
        catch (Exception e) {
            log.error((Object)"could not create RSTEXTWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSTEXTWriter");
        }
    }

    public static RSTEXTWriter getRSTEXTWriter(int recsPerPart, int partSize, boolean wellformed) throws Exception {
        try {
            if (recsPerPart <= 0 || partSize <= 0) {
                log.error((Object)("One or more Illegal values in " + recsPerPart + " or " + partSize));
                throw new Exception("One or more Illegal values in " + recsPerPart + " or " + partSize);
            }
            PropertyElementWellFormed wf = null;
            wf = wellformed ? new PropertyElementWellFormed(PropertyElementWellFormed.YES) : new PropertyElementWellFormed(PropertyElementWellFormed.NO);
            return new RSTEXTWriter(RSFullWriter.getRSFullWriter(new PropertyElementBase[]{new PropertyElementGC(PropertyElementGC.unspecified), new PropertyElementType(PropertyElementType.TEXT), wf}), recsPerPart, partSize, wellformed);
        }
        catch (Exception e) {
            log.error((Object)"could not create RSTEXTWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSTEXTWriter");
        }
    }

    public static RSTEXTWriter getRSTEXTWriter(int recsPerPart, int partSize, boolean wellformed, boolean dataFlow) throws Exception {
        try {
            if (recsPerPart <= 0 || partSize <= 0) {
                log.error((Object)("One or more Illegal values in " + recsPerPart + " or " + partSize));
                throw new Exception("One or more Illegal values in " + recsPerPart + " or " + partSize);
            }
            PropertyElementWellFormed wf = null;
            wf = wellformed ? new PropertyElementWellFormed(PropertyElementWellFormed.YES) : new PropertyElementWellFormed(PropertyElementWellFormed.NO);
            return new RSTEXTWriter(RSFullWriter.getRSFullWriter(new PropertyElementBase[]{new PropertyElementGC(PropertyElementGC.unspecified), new PropertyElementType(PropertyElementType.TEXT), wf}, dataFlow), recsPerPart, partSize, wellformed);
        }
        catch (Exception e) {
            log.error((Object)"could not create RSTEXTWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSTEXTWriter");
        }
    }

    public static RSTEXTWriter getRSTEXTWriter(PropertyElementBase[] properties, boolean wellformed) throws Exception {
        try {
            PropertyElementBase[] props = new PropertyElementBase[properties.length + 2];
            PropertyElementWellFormed wf = null;
            wf = wellformed ? new PropertyElementWellFormed(PropertyElementWellFormed.YES) : new PropertyElementWellFormed(PropertyElementWellFormed.NO);
            System.arraycopy(properties, 0, props, 0, properties.length);
            props[properties.length] = new PropertyElementType(PropertyElementType.TEXT);
            props[properties.length + 1] = wf;
            return new RSTEXTWriter(RSFullWriter.getRSFullWriter(props), wellformed);
        }
        catch (Exception e) {
            log.error((Object)"could not create RSTEXTWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSTEXTWriter");
        }
    }

    public static RSTEXTWriter getRSTEXTWriter(PropertyElementBase[] properties, boolean wellformed, boolean dataFlow) throws Exception {
        try {
            PropertyElementBase[] props = new PropertyElementBase[properties.length + 2];
            PropertyElementWellFormed wf = null;
            wf = wellformed ? new PropertyElementWellFormed(PropertyElementWellFormed.YES) : new PropertyElementWellFormed(PropertyElementWellFormed.NO);
            System.arraycopy(properties, 0, props, 0, properties.length);
            props[properties.length] = new PropertyElementType(PropertyElementType.TEXT);
            props[properties.length + 1] = wf;
            return new RSTEXTWriter(RSFullWriter.getRSFullWriter(props, dataFlow), wellformed);
        }
        catch (Exception e) {
            log.error((Object)"could not create RSTEXTWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSTEXTWriter");
        }
    }

    public static RSTEXTWriter getRSTEXTWriter(PropertyElementBase[] properties, int recsPerPart, int partSize, boolean wellformed) throws Exception {
        try {
            if (recsPerPart <= 0 || partSize <= 0) {
                log.error((Object)("One or more Illegal values in " + recsPerPart + " or " + partSize));
                throw new Exception("One or more Illegal values in " + recsPerPart + " or " + partSize);
            }
            PropertyElementBase[] props = new PropertyElementBase[properties.length + 1];
            PropertyElementWellFormed wf = null;
            wf = wellformed ? new PropertyElementWellFormed(PropertyElementWellFormed.YES) : new PropertyElementWellFormed(PropertyElementWellFormed.NO);
            System.arraycopy(properties, 0, props, 0, properties.length);
            props[properties.length] = new PropertyElementType(PropertyElementType.TEXT);
            props[properties.length + 1] = wf;
            return new RSTEXTWriter(RSFullWriter.getRSFullWriter(props), recsPerPart, partSize, wellformed);
        }
        catch (Exception e) {
            log.error((Object)"could not create RSTEXTWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSTEXTWriter");
        }
    }

    public static RSTEXTWriter getRSTEXTWriter(PropertyElementBase[] properties, int recsPerPart, int partSize, boolean wellformed, boolean dataFlow) throws Exception {
        try {
            if (recsPerPart <= 0 || partSize <= 0) {
                log.error((Object)("One or more Illegal values in " + recsPerPart + " or " + partSize));
                throw new Exception("One or more Illegal values in " + recsPerPart + " or " + partSize);
            }
            PropertyElementBase[] props = new PropertyElementBase[properties.length + 1];
            PropertyElementWellFormed wf = null;
            wf = wellformed ? new PropertyElementWellFormed(PropertyElementWellFormed.YES) : new PropertyElementWellFormed(PropertyElementWellFormed.NO);
            System.arraycopy(properties, 0, props, 0, properties.length);
            props[properties.length] = new PropertyElementType(PropertyElementType.TEXT);
            props[properties.length + 1] = wf;
            return new RSTEXTWriter(RSFullWriter.getRSFullWriter(props, dataFlow), recsPerPart, partSize, wellformed);
        }
        catch (Exception e) {
            log.error((Object)"could not create RSTEXTWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSTEXTWriter");
        }
    }

    protected RSTEXTWriter(RSFullWriter writer, boolean wellformed) {
        this.writer = writer;
        this.records = new Vector();
        this.synchAddition = new Object();
        this.wellformed = wellformed;
    }

    protected RSTEXTWriter(RSFullWriter writer, int recsPerPart, int partSize, boolean wellformed) {
        this.writer = writer;
        this.records = new Vector();
        this.recsPerCount = recsPerPart;
        this.partSize = partSize;
        this.synchAddition = new Object();
        this.wellformed = wellformed;
    }

    public boolean setTimer(long delay, long period, int times) {
        if (this.timer != null || this.task != null || times <= 0) {
            return false;
        }
        try {
            this.timer = new Timer();
            this.task = new ForceProductionTask(this, this.synchAddition, times);
            this.timer.schedule((TimerTask)this.task, delay, period);
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Caught Exception while trying to create Timer. returning false", (Throwable)e);
            return false;
        }
    }

    public boolean resetTimer() {
        if (this.timer == null && this.task == null) {
            return false;
        }
        if (this.task != null) {
            this.task.cancel();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
        this.task = null;
        return true;
    }

    public boolean isTimerAlive() {
        if (this.timer == null || this.task == null) {
            return false;
        }
        return this.task.isAlive();
    }

    public void setRecsPerPart(int rpp) throws Exception {
        if (rpp <= 0) {
            log.error((Object)("Could not set RecsPerPart. Illegal value " + rpp));
            throw new Exception("Could not set RecsPerPart. Illegal value " + rpp);
        }
        this.recsPerCount = rpp;
    }

    public void setPartSize(int partSize) throws Exception {
        if (partSize <= 0) {
            log.error((Object)("Could not set PartSize. Illegal value " + partSize));
            throw new Exception("Could not set PartSize. Illegal value " + partSize);
        }
        this.partSize = partSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSLocator getRSLocator(RSResourceType type, GCUBEScope scope) throws Exception {
        try {
            Object object = this.synchAddition;
            synchronized (object) {
                return this.writer.getRSLocator(type, scope);
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not retrieve RSLocator. Throwing Exception", (Throwable)e);
            throw new Exception("Could not retrieve RSLocator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSLocator getRSLocator(RSResourceType type) throws Exception {
        try {
            Object object = this.synchAddition;
            synchronized (object) {
                return this.writer.getRSLocator(type);
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not retrieve RSLocator. Throwing Exception", (Throwable)e);
            throw new Exception("Could not retrieve RSLocator");
        }
    }

    public RSConstants.CONTROLFLOW more(long time) throws Exception {
        try {
            return this.writer.more(time);
        }
        catch (Exception e) {
            log.error((Object)"Could not check if more records are needed. Throwing Exception", (Throwable)e);
            throw new Exception("Could not check if more records are needed");
        }
    }

    public boolean isFlowControled() throws Exception {
        return this.writer.isFlowControled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResults(String record) throws Exception {
        if (this.records == null) {
            log.error((Object)"records vector is null. Incorrect initialization incorrect. Throwing Exception");
            throw new Exception("records vector is null. Incorrect initialization incorrect");
        }
        Object object = this.synchAddition;
        synchronized (object) {
            try {
                this.size += record.getBytes().length;
                if (this.records.size() + 1 >= this.recsPerCount) {
                    this.records.add(record);
                    if (this.wellformed) {
                        this.writer.addText("<Head>" + Integer.toString(this.records.size()) + "</" + "Head" + ">");
                        this.writer.addText("<ResultSet>");
                    } else {
                        this.writer.addText(Integer.toString(this.records.size()));
                    }
                    this.writer.addText(this.records.toArray(new String[0]));
                    if (this.wellformed) {
                        this.writer.addText("</ResultSet>");
                    }
                    this.writer.startNewPart();
                    this.size = 0;
                    this.records.clear();
                } else {
                    this.records.add(record);
                }
                if (this.size > this.partSize) {
                    this.writeThrough();
                }
            }
            catch (Exception e) {
                log.error((Object)"Could not perform addition. Throwing Exception", (Throwable)e);
                throw new Exception("Could not perform addition");
            }
        }
    }

    public boolean writeThrough() throws Exception {
        if (this.records == null) {
            log.error((Object)"records vector is null. Incorrect initialization incorrect. Throwing Exception");
            throw new Exception("records vector is null. Incorrect initialization incorrect");
        }
        Object object = this.synchAddition;
        synchronized (object) {
            try {
                if (this.records.size() > 0) {
                    if (this.wellformed) {
                        this.writer.addText("<Head>" + Integer.toString(this.records.size()) + "</" + "Head" + ">");
                        this.writer.addText("<ResultSet>");
                    } else {
                        this.writer.addText(Integer.toString(this.records.size()));
                    }
                    this.writer.addText(this.records.toArray(new String[0]));
                    if (this.wellformed) {
                        this.writer.addText("</ResultSet>");
                    }
                    this.writer.startNewPart();
                    this.size = 0;
                    this.records.clear();
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                log.error((Object)"Could not perform writeTrhough. Throwing Exception", (Throwable)e);
                throw new Exception("Could not perform writeTrhough");
            }
        }
    }

    public void force() throws Exception {
        try {
            if (!this.writeThrough()) {
                this.writer.startNewPart();
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not perform force. Throwing Exception", (Throwable)e);
            throw new Exception("Could not perform force");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResults(String[] record) throws Exception {
        if (this.records == null) {
            log.error((Object)"records vector is null. Incorrect initialization incorrect. Throwing Exception");
            throw new Exception("records vector is null. Incorrect initialization incorrect");
        }
        Object object = this.synchAddition;
        synchronized (object) {
            try {
                for (int i = 0; i < record.length; ++i) {
                    this.addResults(record[i]);
                }
            }
            catch (Exception e) {
                log.error((Object)"Could not perform addition. Throwing Exception", (Throwable)e);
                throw new Exception("Could not perform addition");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        if (this.records == null) {
            this.resetTimer();
            log.error((Object)"records vector is null. Incorrect initialization incorrect. Throwing Exception");
            throw new Exception("records vector is null. Incorrect initialization incorrect");
        }
        this.resetTimer();
        Object object = this.synchAddition;
        synchronized (object) {
            try {
                if (this.records.size() > 0) {
                    if (this.wellformed) {
                        this.writer.addText("<Head>" + Integer.toString(this.records.size()) + "</" + "Head" + ">");
                        this.writer.addText("<ResultSet>");
                    } else {
                        this.writer.addText(Integer.toString(this.records.size()));
                    }
                    this.writer.addText(this.records.toArray(new String[0]));
                    if (this.wellformed) {
                        this.writer.addText("</ResultSet>");
                    }
                    this.size = 0;
                    this.records.clear();
                }
                this.force();
                this.writer.endAuthoring();
            }
            catch (Exception e) {
                log.error((Object)"Could not perform addition. Throwing Exception", (Throwable)e);
                throw new Exception("Could not perform addition");
            }
        }
    }

    public void wrapFile(String filename) throws Exception {
        try {
            this.writer.wrapFile(filename);
        }
        catch (Exception e) {
            log.error((Object)"Could not wrap file. Throwing Exception", (Throwable)e);
            throw new Exception("Could not wrap file");
        }
    }

    public void overrideProperties(PropertyElementBase[] properties) throws Exception {
        try {
            this.writer.overrideProperties(properties);
        }
        catch (Exception e) {
            log.error((Object)"could not override properties. Throwing Exception", (Throwable)e);
            throw new Exception("could not override properties");
        }
    }

    public void overrideProperties(String properties) throws Exception {
        try {
            this.writer.overrideProperties(properties);
        }
        catch (Exception e) {
            log.error((Object)"could not override properties. Throwing Exception", (Throwable)e);
            throw new Exception("could not override properties");
        }
    }
}

