/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.resultsetservice;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.log4j.Logger;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.searchservice.searchlibrary.resultset.ResultSet;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.CreationParams;
import org.globus.wsrf.ResourceException;
import sun.misc.BASE64Decoder;

public class ResultSetResource
extends GCUBEWSResource {
    private static Logger log = Logger.getLogger(ResultSetResource.class);
    protected static String[] RPNames = new String[0];
    protected ResultSet _rs = null;

    private void initialize(String[] properties, boolean dataFlow) throws Exception {
        try {
            this.setResultSet(new ResultSet(properties, dataFlow));
        }
        catch (Exception e) {
            log.error((Object)"Could not initialize resource. Throwing Exception", (Throwable)e);
            throw new Exception("Could not initialize resource");
        }
    }

    private void initializeSerialized(String properties, boolean dataFlow) throws Exception {
        try {
            this.setResultSet(new ResultSet(properties, dataFlow));
        }
        catch (Exception e) {
            log.error((Object)"Could not initialize resource. Throwing Exception", (Throwable)e);
            throw new Exception("Could not initialize resource");
        }
    }

    private void initialize(String headFileName) throws Exception {
        try {
            this.setResultSet(new ResultSet(headFileName));
        }
        catch (Exception e) {
            log.error((Object)"Could not initialize resource. Throwinhg Exception", (Throwable)e);
            throw new Exception("Could not initialize resource");
        }
    }

    private void initialize(String headFileName, PrivateKey pk) throws Exception {
        try {
            this.setResultSet(new ResultSet(headFileName, pk));
        }
        catch (Exception e) {
            log.error((Object)"Could not initialize resource. Throwinhg Exception", (Throwable)e);
            throw new Exception("Could not initialize resource");
        }
    }

    public ResultSet getResultSet() {
        return this._rs;
    }

    public synchronized void setResultSet(ResultSet value) throws Exception {
        this._rs = value;
    }

    private void initialize(CreationParams createParams) throws Exception {
        try {
            this.setResultSet(new ResultSet(createParams));
        }
        catch (Exception e) {
            log.error((Object)"Could not initialize resource. Throwing Exception", (Throwable)e);
            throw new Exception("Could not initialize resource");
        }
    }

    protected void initialise(Object ... args) throws ResourceException {
        log.debug((Object)"Into ResultSetResource.initialise() method...");
        if (args.length != 1 && args.length != 2 && args.length != 6) {
            throw new IllegalArgumentException("The initialise() method of the ResultSetResource should only take one or two arguments.\nConsequently, the ResourceHome create() method should only take one argument of type Object[] of size 1 or 2.");
        }
        try {
            if (args.length == 1) {
                if (args[0] instanceof Boolean) {
                    log.info((Object)"Creation of the global Result Set Service resource that expresses the Garbage Collector");
                } else {
                    this.initialize((String)args[0]);
                }
            } else if (args.length == 2) {
                if (args[0] instanceof String) {
                    if (args[1] instanceof Boolean) {
                        String properties = (String)args[0];
                        boolean dataFlow = (Boolean)args[1];
                        this.initializeSerialized(properties, dataFlow);
                    } else {
                        String headerFileName = (String)args[0];
                        if (args[1] != null) {
                            byte[] encodedKey = (byte[])args[1];
                            byte[] rawkey = new BASE64Decoder().decodeBuffer(new String(encodedKey));
                            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(rawkey);
                            KeyFactory factory = KeyFactory.getInstance("RSA");
                            RSAPrivateKey pk = (RSAPrivateKey)factory.generatePrivate(spec);
                            this.initialize(headerFileName, pk);
                        } else {
                            this.initialize(headerFileName);
                        }
                    }
                } else if (args[0] instanceof String[]) {
                    String[] properties = (String[])args[0];
                    boolean dataFlow = (Boolean)args[1];
                    this.initialize(properties, dataFlow);
                }
            } else if (args.length == 6) {
                CreationParams createParams = new CreationParams();
                createParams.properties = new ArrayList<String>(Arrays.asList((String[])args[0]));
                createParams.setDataflow(((Boolean)args[1]).booleanValue());
                createParams.setAccessReads(((Integer)args[2]).intValue());
                createParams.setForward(((Boolean)args[3]).booleanValue());
                Date expire_date = new Date(0L);
                expire_date.setTime((Long)args[4]);
                createParams.setExpire_date(expire_date);
                if (args[5] != null) {
                    byte[] encodedKey = (byte[])args[5];
                    byte[] rawkey = new BASE64Decoder().decodeBuffer(new String(encodedKey));
                    X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(rawkey);
                    KeyFactory kf = KeyFactory.getInstance("RSA");
                    RSAPublicKey pk = (RSAPublicKey)kf.generatePublic(publicKeySpec);
                    createParams.setPKey((PublicKey)pk);
                }
                this.initialize(createParams);
            }
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }
}

