/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.rseprcache;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.namespace.QName;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.ObjectExistsException;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.search.rseprcache.NotificationConsumer;
import org.gcube.search.rseprcache.ParsingUtils;

public class RSEPRCache {
    private NotificationConsumer consumer;
    private GCUBEScope scope;
    private GCUBESecurityManager sman;
    private static CacheManager manager = CacheManager.create((URL)RSEPRCache.class.getResource("/etc/config/ehcache1.xml"));
    private Cache cache;
    private HashMap<String, ArrayList<Object>> eprkeys;
    private static GCUBELog logger = new GCUBELog(RSEPRCache.class);
    private static final String topicNS = "http://gcube.org/namespaces/searchservice/ResultSetService";
    private static final String topicName = "ReclaimingRSEprs";
    private long ttl;
    private long tti;
    private int maxElementsInMemory;
    private boolean overflowToDisk;

    public RSEPRCache(GCUBESecurityManager gCUBESecurityManager, GCUBEScope gCUBEScope) throws Exception {
        this.scope = gCUBEScope;
        this.sman = gCUBESecurityManager;
        if (!this.loadProperties("/etc/config/default.properties")) {
            throw new Exception("could not load QueryCache properties. Make sure there is a /etc/config/default.properties file inside the Querycache jar file");
        }
        this.newCache();
    }

    public RSEPRCache(GCUBEServiceContext gCUBEServiceContext) throws Exception {
        this.sman = gCUBEServiceContext;
        this.scope = gCUBEServiceContext == null ? null : gCUBEServiceContext.getScope();
        if (!this.loadProperties("/etc/config/default.properties")) {
            throw new Exception("could not load QueryCache properties. Make sure there is a /etc/config/default.properties file inside the Querycache jar file");
        }
        this.newCache();
    }

    public RSEPRCache(GCUBEServiceContext gCUBEServiceContext, long l, long l2, int n) throws Exception {
        this.sman = gCUBEServiceContext;
        this.scope = gCUBEServiceContext == null ? null : gCUBEServiceContext.getScope();
        this.ttl = l;
        this.tti = l2;
        this.maxElementsInMemory = n;
        this.overflowToDisk = false;
        this.newCache();
    }

    private void newCache() throws Exception {
        if (this.scope == null) {
            throw new Exception("There is no scope passed for the creation of the new cache instance");
        }
        String string = String.valueOf(this.hashCode());
        Cache cache = new Cache(string, this.maxElementsInMemory, this.overflowToDisk, false, this.ttl, this.tti, false, 150L);
        try {
            manager.addCache(cache);
        }
        catch (ObjectExistsException objectExistsException) {
            logger.info((Object)("Cache: " + string + " already defined"));
        }
        this.cache = manager.getCache(string);
        this.eprkeys = new HashMap();
        this.consumer = new NotificationConsumer(this.cache, this.eprkeys);
        try {
            ISNotifier iSNotifier = (ISNotifier)GHNContext.getImplementation(ISNotifier.class);
            QName qName = new QName(topicNS, topicName);
            ArrayList<ISNotifier.GCUBENotificationTopic> arrayList = new ArrayList<ISNotifier.GCUBENotificationTopic>();
            ISNotifier.GCUBENotificationTopic gCUBENotificationTopic = new ISNotifier.GCUBENotificationTopic(qName);
            gCUBENotificationTopic.setUseRenotifier(true);
            arrayList.add(gCUBENotificationTopic);
            iSNotifier.registerToISNotification((ISNotifier.BaseNotificationConsumer)this.consumer, arrayList, this.sman, new GCUBEScope[]{this.scope});
        }
        catch (Exception exception) {
            logger.error((Object)"Could not register to topic for removing ResultSet eprs!!! RS EPR Cache won't be refreshed automatically", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object object, String string) throws Exception {
        String string2 = ParsingUtils.deserializeEPR(string).toString();
        Cache cache = this.cache;
        synchronized (cache) {
            this.cache.put(new Element(object, (Object)string));
            if (this.eprkeys.containsKey(string2)) {
                ArrayList<Object> arrayList = this.eprkeys.get(string2);
                if (!arrayList.contains(object)) {
                    arrayList.add(object);
                    this.eprkeys.put(string2, arrayList);
                }
            } else {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(object);
                this.eprkeys.put(string2, arrayList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Object object) {
        Cache cache = this.cache;
        synchronized (cache) {
            Element element = this.cache.get(object);
            if (element != null) {
                return (String)element.getObjectValue();
            }
            return null;
        }
    }

    public int size() {
        return this.cache.getSize();
    }

    private boolean loadProperties(String string) {
        Properties properties = null;
        try {
            properties = new Properties();
            properties.load(RSEPRCache.class.getResourceAsStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.error((Object)(" *** File not found *** " + string));
            return false;
        }
        catch (IOException iOException) {
            logger.error((Object)(" *** Properties not loaded *** " + string));
            return false;
        }
        this.maxElementsInMemory = Integer.parseInt(properties.getProperty("maxElementsInMemory"));
        this.tti = Long.parseLong(properties.getProperty("timeToIdleSeconds"));
        this.ttl = Long.parseLong(properties.getProperty("timeToLiveSeconds"));
        this.overflowToDisk = Boolean.parseBoolean(properties.getProperty("overflowToDisk"));
        return true;
    }
}

