/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.client.library.proxies;

import gr.uoa.di.madgik.grs.record.GenericRecord;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.search.client.library.beans.Types;
import org.gcube.search.client.library.exceptions.SearchException;
import org.gcube.search.client.library.proxies.SearchCLProxyI;
import org.gcube.search.client.library.stubs.SearchStub;

public class SearchCLDefaultProxy
implements SearchCLProxyI {
    private final ProxyDelegate<SearchStub> delegate;

    public SearchCLDefaultProxy(ProxyDelegate<SearchStub> config) {
        this.delegate = config;
    }

    @Override
    public Stream<GenericRecord> search(final String query) throws SearchException {
        Call<SearchStub, Types.SearchResponse> call = new Call<SearchStub, Types.SearchResponse>(){

            public Types.SearchResponse call(SearchStub endpoint) {
                return endpoint.search(query);
            }
        };
        Types.SearchResponse searchResponse = null;
        try {
            searchResponse = (Types.SearchResponse)this.delegate.make((Call)call);
        }
        catch (Exception e1) {
            throw new SearchException(e1);
        }
        String rsLocator = searchResponse.epr;
        URI rsURI = null;
        try {
            rsURI = new URI(rsLocator);
        }
        catch (URISyntaxException e2) {
            throw new SearchException(e2);
        }
        Stream stream = Streams.convert((URI)rsURI).of(GenericRecord.class).withTimeout(60, TimeUnit.SECONDS);
        return stream;
    }
}

