/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchDiscoverer {
    public static final String ENDPOINT_KEY = "resteasy-servlet";
    public static final String SERVICE_CLASS = "Search";
    public static final String SERVICE_NAME = "SearchSystemService";
    private static final Logger logger = LoggerFactory.getLogger(SearchDiscoverer.class);

    public static List<String> discoverSearchServices(String scope) {
        return SearchDiscoverer.discoverRunningInstances(SERVICE_NAME, SERVICE_CLASS, scope);
    }

    public static List<String> discoverRunningInstances(String serviceName, String serviceClass, String scope) {
        logger.info("Discovering : serviceName " + serviceName + " serviceClass, " + serviceClass + " scope : " + scope);
        ArrayList<String> endpoints = new ArrayList<String>();
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceClass/text() eq '" + serviceClass + "'").addCondition("$resource/Profile/ServiceName/text() eq '" + serviceName + "'");
        DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
        List resources = client.submit((Query)query);
        for (GCoreEndpoint se : resources) {
            GCoreEndpoint.Profile.Endpoint endpoint;
            if (se == null || se.profile() == null || se.profile().endpointMap() == null || (endpoint = (GCoreEndpoint.Profile.Endpoint)se.profile().endpointMap().get(ENDPOINT_KEY)) == null || endpoint.uri() == null) continue;
            endpoints.add(endpoint.uri().toString());
        }
        logger.info("endpoints found in discovering : " + endpoints);
        return endpoints;
    }
}

