package org.gcube.search;

import java.util.Set;

import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.Consumes;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;


public interface SearchServiceClientAPI {
	public static String SCOPE_HEADER = "gcube-scope";

	@GET
	@Path("search")
	@Consumes("text/plain")
	@Produces(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
	Response search(@HeaderParam(SCOPE_HEADER) String scope, @QueryParam("query") String query, @QueryParam("all") Boolean all, @QueryParam("pretty") Boolean pretty, @QueryParam("names") Boolean names);

	@GET
	@Path("searchSec")
	@Consumes("text/plain")
	@Produces(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
	Response searchSec(@HeaderParam(SCOPE_HEADER) String scope, @QueryParam("query") String query, @QueryParam("all") Boolean all, @QueryParam("pretty") Boolean pretty, @QueryParam("names") Boolean names, @QueryParam("sids") Set<String> sids);
	
}
