/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.searchsystem.planning.maxsubtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.gcube.searchsystem.planning.commonvocabulary.IndexRelationCommonSemantics;
import org.gcube.searchsystem.planning.exception.CQLUnsupportedException;
import org.gcube.searchsystem.planning.maxsubtree.AndTree;
import org.gcube.searchsystem.planning.maxsubtree.GeneralTreeNode;
import org.gcube.searchsystem.planning.maxsubtree.TreeTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import search.library.util.cql.query.tree.ModifierSet;

public class TwoPhaseComposer {
    private Logger logger = LoggerFactory.getLogger((String)TwoPhaseComposer.class.getName());
    private ArrayList<AndTree> subtrees;
    private Vector<ModifierSet> projections;

    public TwoPhaseComposer(ArrayList<AndTree> subtrees, Vector<ModifierSet> projections) {
        this.subtrees = subtrees;
        this.projections = projections;
    }

    public GeneralTreeNode compose() throws CQLUnsupportedException {
        HashMap<TreeTransformer.GCQLCondition, Set<Integer>> factorTrees = this.createFactorMap(this.subtrees);
        HashSet<Integer> treesLeft = new HashSet<Integer>();
        for (int i = 0; i < this.subtrees.size(); ++i) {
            treesLeft.add(new Integer(i));
        }
        return this.allInOnePhase(treesLeft, this.subtrees, factorTrees);
    }

    private GeneralTreeNode allInOnePhase(Set<Integer> treesLeft, ArrayList<AndTree> currentSubtrees, HashMap<TreeTransformer.GCQLCondition, Set<Integer>> factorTrees) throws CQLUnsupportedException {
        this.logger.trace("AllInOnePhase called for trees: " + Arrays.toString((Object[])treesLeft.toArray(new Integer[treesLeft.size()])));
        for (AndTree tree : currentSubtrees) {
            this.logger.trace("Tree for collection: " + tree.collection + ", language: " + tree.language);
            for (int i = 0; i < tree.conditions.size(); ++i) {
                TreeTransformer.GCQLCondition condition = tree.conditions.get(i);
                this.logger.trace("Not: " + condition.not + ", term: " + condition.term.toCQL());
                this.logger.trace("Sources: " + Arrays.toString(tree.sources.get(i).toArray(new String[tree.sources.get(i).size()])));
            }
        }
        ArrayList<Integer> treesToBeExamined = new ArrayList<Integer>(treesLeft);
        ArrayList<Integer> treesForFactorization = new ArrayList<Integer>();
        ArrayList groupedTrees = new ArrayList();
        ArrayList<HashSet<String>> groupedSources = new ArrayList<HashSet<String>>();
        while (treesToBeExamined.size() > 0) {
            Integer currentTree = treesToBeExamined.get(0);
            treesToBeExamined.remove(0);
            HashSet<String> currentSources = this.getSourcesSatisfyingTree(currentSubtrees.get(currentTree));
            if (currentSources == null) {
                treesForFactorization.add(currentTree);
                continue;
            }
            ArrayList<Integer> currentGroupedTrees = new ArrayList<Integer>();
            currentGroupedTrees.add(currentTree);
            Iterator<Integer> treesIter = treesToBeExamined.iterator();
            while (treesIter.hasNext()) {
                Integer tmpTree = treesIter.next();
                HashSet<String> tmpSources = this.getSourcesSatisfyingTree(currentSubtrees.get(tmpTree));
                if (tmpSources == null) {
                    treesForFactorization.add(tmpTree);
                    treesIter.remove();
                    continue;
                }
                tmpSources.retainAll(currentSources);
                if (tmpSources.size() == 0) continue;
                currentGroupedTrees.add(tmpTree);
                treesIter.remove();
                currentSources = tmpSources;
            }
            groupedTrees.add(currentGroupedTrees);
            groupedSources.add(currentSources);
        }
        this.logger.trace("trees for factorization: " + Arrays.toString((Object[])treesForFactorization.toArray(new Integer[treesForFactorization.size()])));
        GeneralTreeNode orNode = null;
        GeneralTreeNode leaf = null;
        if (groupedTrees.size() > 1) {
            orNode = new GeneralTreeNode();
            orNode.type = GeneralTreeNode.NodeType.OR;
        }
        for (int i = 0; i < groupedTrees.size(); ++i) {
            ArrayList treeGroup = (ArrayList)groupedTrees.get(i);
            Set sourceGroup = (Set)groupedSources.get(i);
            this.logger.trace("group: " + Arrays.toString((Object[])treeGroup.toArray(new Integer[treeGroup.size()])));
            this.logger.trace("sources for this group: " + Arrays.toString(sourceGroup.toArray(new String[sourceGroup.size()])));
            leaf = new GeneralTreeNode();
            leaf.type = GeneralTreeNode.NodeType.LEAF;
            leaf.sources = sourceGroup;
            ArrayList<AndTree> andTrees = new ArrayList<AndTree>();
            for (Integer treeNum : treeGroup) {
                andTrees.add(currentSubtrees.get(treeNum));
            }
            leaf.colLangs = new HashMap();
            leaf.gcql = IndexRelationCommonSemantics.createGCQLNodeFromAndTrees(andTrees, leaf.colLangs);
            this.logger.trace("CQL: " + leaf.gcql);
            if (orNode == null) continue;
            orNode.children.add(leaf);
        }
        GeneralTreeNode factorNode = null;
        if (treesForFactorization.size() > 0) {
            ArrayList<AndTree> newCurrentSubtrees = new ArrayList<AndTree>();
            for (int i = 0; i < this.subtrees.size(); ++i) {
                newCurrentSubtrees.add(new AndTree());
            }
            for (Integer treeSeqNum : treesForFactorization) {
                newCurrentSubtrees.remove(treeSeqNum);
                newCurrentSubtrees.add(treeSeqNum, this.createAndTree(new ArrayList<TreeTransformer.GCQLCondition>(), currentSubtrees.get(treeSeqNum)));
            }
            factorNode = this.factorizationPhase(new HashSet<Integer>(treesForFactorization), this.createFactorMap(newCurrentSubtrees), newCurrentSubtrees);
            if (orNode == null && leaf == null) {
                return factorNode;
            }
            if (orNode == null && leaf != null) {
                orNode = new GeneralTreeNode();
                orNode.type = GeneralTreeNode.NodeType.OR;
                orNode.children.add(leaf);
                orNode.children.add(factorNode);
            } else if (orNode != null) {
                orNode.children.add(factorNode);
            }
        }
        if (orNode == null) {
            if (leaf == null) {
                throw new CQLUnsupportedException("While applying the AllInOnePhase we ended up with no output");
            }
            this.logger.trace(leaf.toString());
            return leaf;
        }
        this.logger.trace(orNode.toString());
        return orNode;
    }

    private HashSet<String> getSourcesSatisfyingTree(AndTree andTree) {
        HashSet result = null;
        for (Set set : andTree.sources) {
            if (result == null) {
                result = new HashSet(set);
                continue;
            }
            result.retainAll(set);
            if (result.size() != 0) continue;
            return null;
        }
        return result;
    }

    private HashMap<TreeTransformer.GCQLCondition, Set<Integer>> createFactorMap(ArrayList<AndTree> currentSubtrees) {
        HashMap<TreeTransformer.GCQLCondition, Set<Integer>> factorTrees = new HashMap<TreeTransformer.GCQLCondition, Set<Integer>>();
        int i = 0;
        for (AndTree tree : currentSubtrees) {
            for (TreeTransformer.GCQLCondition factor : tree.getConditions()) {
                Set<Integer> referencedIn = factorTrees.get(factor);
                if (referencedIn == null) {
                    referencedIn = new HashSet<Integer>();
                    factorTrees.put(factor, referencedIn);
                }
                referencedIn.add(new Integer(i));
            }
            ++i;
        }
        return factorTrees;
    }

    /*
     * WARNING - void declaration
     */
    private GeneralTreeNode factorizationPhase(Set<Integer> treesLeft, HashMap<TreeTransformer.GCQLCondition, Set<Integer>> factorTrees, ArrayList<AndTree> currentSubtrees) throws CQLUnsupportedException {
        boolean firstStep = true;
        GeneralTreeNode matchedFactorsNode = null;
        GeneralTreeNode generalOrNode = null;
        while (true) {
            void var17_30;
            this.logger.trace("FactorizationPhase applied for trees: " + Arrays.toString((Object[])treesLeft.toArray(new Integer[treesLeft.size()])));
            for (AndTree tree : currentSubtrees) {
                this.logger.trace("Tree for collection: " + tree.collection + ", language: " + tree.language);
                for (int i = 0; i < tree.conditions.size(); ++i) {
                    TreeTransformer.GCQLCondition condition = tree.conditions.get(i);
                    this.logger.trace("Not: " + condition.not + ", term: " + condition.term.toCQL());
                    this.logger.trace("Sources: " + Arrays.toString(tree.sources.get(i).toArray(new String[tree.sources.get(i).size()])));
                }
            }
            Set<Integer> maxSet = null;
            for (Map.Entry<TreeTransformer.GCQLCondition, Set<Integer>> current : factorTrees.entrySet()) {
                if (maxSet != null && current.getValue().size() <= maxSet.size()) continue;
                maxSet = current.getValue();
            }
            this.logger.trace("MaxSet factor: " + Arrays.toString((Object[])maxSet.toArray(new Integer[maxSet.size()])));
            Set newMaxSet = (Set)((HashSet)maxSet).clone();
            int maxSize = newMaxSet.size();
            ArrayList<TreeTransformer.GCQLCondition> maxFactors = new ArrayList<TreeTransformer.GCQLCondition>();
            HashMap currentFactorTrees = new HashMap();
            for (Map.Entry<TreeTransformer.GCQLCondition, Set<Integer>> current : factorTrees.entrySet()) {
                HashSet newSet = new HashSet(current.getValue());
                newSet.retainAll(newMaxSet);
                if (newSet.size() <= 0) continue;
                currentFactorTrees.put(current.getKey(), newSet);
                if (newSet.size() != maxSize) continue;
                maxFactors.add(current.getKey());
            }
            ArrayList<ArrayList<Set<String>>> minimalSourceSets = new ArrayList<ArrayList<Set<String>>>();
            for (TreeTransformer.GCQLCondition condition : maxFactors) {
                this.logger.trace("Factor: " + condition.getTerm().toCQL() + ", Not: " + condition.not);
                ArrayList<Set<String>> sourceSets = this.findShortestListOfSources(condition, (Set)currentFactorTrees.get(condition));
                this.logger.trace("Sources: ");
                for (Set set : sourceSets) {
                    this.logger.trace(Arrays.toString(set.toArray(new String[set.size()])));
                }
                minimalSourceSets.add(sourceSets);
            }
            matchedFactorsNode = this.matchFactorSources(maxFactors, newMaxSet, minimalSourceSets);
            this.logger.trace(matchedFactorsNode.toString());
            ArrayList<AndTree> newCurrentSubtrees = new ArrayList<AndTree>();
            for (int i = 0; i < this.subtrees.size(); ++i) {
                newCurrentSubtrees.add(new AndTree());
            }
            boolean atLeastOne = false;
            HashSet<Integer> treeSetForAllInOne = new HashSet<Integer>(newMaxSet);
            for (Integer n : newMaxSet) {
                AndTree newTree = this.createAndTree(maxFactors, currentSubtrees.get(n));
                if (newTree.conditions.size() > 0) {
                    newCurrentSubtrees.remove(n);
                    newCurrentSubtrees.add(n, newTree);
                    atLeastOne = true;
                    continue;
                }
                treeSetForAllInOne.remove((int)n);
            }
            if (atLeastOne) {
                GeneralTreeNode generalNode = this.allInOnePhase(treeSetForAllInOne, newCurrentSubtrees, this.createFactorMap(newCurrentSubtrees));
                if (matchedFactorsNode.type.equals((Object)GeneralTreeNode.NodeType.AND)) {
                    matchedFactorsNode.children.add(generalNode);
                } else {
                    GeneralTreeNode generalTreeNode = new GeneralTreeNode();
                    generalTreeNode.type = GeneralTreeNode.NodeType.AND;
                    generalTreeNode.children.add(matchedFactorsNode);
                    generalTreeNode.children.add(generalNode);
                    matchedFactorsNode = generalTreeNode;
                }
            }
            treesLeft.removeAll(newMaxSet);
            if (treesLeft.size() <= 0) break;
            Iterator<Map.Entry<TreeTransformer.GCQLCondition, Set<Integer>>> iter = factorTrees.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<TreeTransformer.GCQLCondition, Set<Integer>> entry = iter.next();
                entry.getValue().removeAll(newMaxSet);
                if (entry.getValue().size() != 0) continue;
                iter.remove();
            }
            newCurrentSubtrees = new ArrayList();
            boolean bl = false;
            while (var17_30 < this.subtrees.size()) {
                newCurrentSubtrees.add(new AndTree());
                ++var17_30;
            }
            for (Integer treeSeqNum : treesLeft) {
                newCurrentSubtrees.remove(treeSeqNum);
                newCurrentSubtrees.add(treeSeqNum, this.createAndTree(new ArrayList<TreeTransformer.GCQLCondition>(), currentSubtrees.get(treeSeqNum)));
            }
            currentSubtrees = newCurrentSubtrees;
            if (firstStep) {
                generalOrNode = new GeneralTreeNode();
                generalOrNode.type = GeneralTreeNode.NodeType.OR;
                generalOrNode.children.add(matchedFactorsNode);
                firstStep = false;
                continue;
            }
            generalOrNode.children.add(matchedFactorsNode);
        }
        if (firstStep) {
            return matchedFactorsNode;
        }
        generalOrNode.children.add(matchedFactorsNode);
        return generalOrNode;
    }

    private GeneralTreeNode matchFactorSources(ArrayList<TreeTransformer.GCQLCondition> maxFactors, Set<Integer> newMaxSet, ArrayList<ArrayList<Set<String>>> minimalSourceSets) {
        ArrayList factors = (ArrayList)maxFactors.clone();
        HashMap<TreeTransformer.GCQLCondition, ArrayList<Set<String>>> factorSourcesMap = new HashMap<TreeTransformer.GCQLCondition, ArrayList<Set<String>>>();
        for (int i = 0; i < maxFactors.size(); ++i) {
            factorSourcesMap.put(maxFactors.get(i), minimalSourceSets.get(i));
        }
        ArrayList matchedFactors = new ArrayList();
        ArrayList matchedSources = new ArrayList();
        while (factors.size() > 0) {
            ArrayList currentMatching = new ArrayList();
            currentMatching.add(factors.get(0));
            matchedFactors.add(currentMatching);
            ArrayList currentSourceMatching = (ArrayList)factorSourcesMap.get(factors.get(0));
            factors.remove(0);
            Iterator factorIter = factors.iterator();
            block2: while (factorIter.hasNext()) {
                TreeTransformer.GCQLCondition currentFactor = (TreeTransformer.GCQLCondition)factorIter.next();
                ArrayList sourcesList = (ArrayList)factorSourcesMap.get(currentFactor);
                if (sourcesList.size() != currentSourceMatching.size()) continue;
                ArrayList tmpList = new ArrayList();
                for (int k = 0; k < sourcesList.size(); ++k) {
                    HashSet tmpSet = new HashSet((Collection)sourcesList.get(k));
                    tmpSet.retainAll((Collection)currentSourceMatching.get(k));
                    if (tmpSet.size() == 0) continue block2;
                    tmpList.add(tmpSet);
                }
                currentSourceMatching = tmpList;
                currentMatching.add(currentFactor);
                factorIter.remove();
            }
            matchedSources.add(currentSourceMatching);
        }
        GeneralTreeNode root = null;
        if (matchedFactors.size() > 1) {
            root = new GeneralTreeNode();
            root.type = GeneralTreeNode.NodeType.AND;
        }
        for (int i = 0; i < matchedFactors.size(); ++i) {
            ArrayList mFactors = (ArrayList)matchedFactors.get(i);
            ArrayList mSources = (ArrayList)matchedSources.get(i);
            GeneralTreeNode orNode = null;
            for (int j = 0; j < mSources.size(); ++j) {
                HashMap<String, HashSet<String>> colLangs = this.getColLangsForFactorSources(mFactors, (Set)mSources.get(j), newMaxSet);
                GeneralTreeNode leaf = new GeneralTreeNode();
                leaf.type = GeneralTreeNode.NodeType.LEAF;
                leaf.sources = (Set)mSources.get(j);
                leaf.colLangs = colLangs;
                leaf.gcql = IndexRelationCommonSemantics.createGCQLNodeFromMatchedFactors(mFactors, colLangs);
                if (mSources.size() == 1) {
                    if (root == null) {
                        return leaf;
                    }
                    root.children.add(leaf);
                    continue;
                }
                if (orNode == null) {
                    orNode = new GeneralTreeNode();
                    orNode.type = GeneralTreeNode.NodeType.OR;
                }
                orNode.children.add(leaf);
            }
            if (orNode == null) continue;
            if (root == null) {
                return orNode;
            }
            root.children.add(orNode);
        }
        return root;
    }

    private HashMap<String, HashSet<String>> getColLangsForFactorSources(ArrayList<TreeTransformer.GCQLCondition> matchedFactors, Set<String> sourceSet, Set<Integer> referencedIn) {
        HashMap<String, HashSet<String>> result = new HashMap<String, HashSet<String>>();
        HashSet<TreeTransformer.GCQLCondition> factors = new HashSet<TreeTransformer.GCQLCondition>(matchedFactors);
        block0: for (Integer treeSeqNum : referencedIn) {
            AndTree currentTree = this.subtrees.get(treeSeqNum);
            HashSet<String> sources = new HashSet<String>(sourceSet);
            for (int i = 0; i < currentTree.conditions.size(); ++i) {
                if (!factors.contains(currentTree.conditions.get(i))) continue;
                sources.retainAll((Collection)currentTree.sources.get(i));
                if (sources.size() == 0) continue block0;
            }
            HashSet<String> langs = result.get(currentTree.collection);
            if (langs == null) {
                langs = new HashSet();
                result.put(currentTree.collection, langs);
            }
            langs.add(currentTree.language);
        }
        return result;
    }

    private AndTree createAndTree(ArrayList<TreeTransformer.GCQLCondition> maxFactors, AndTree andTree) {
        AndTree newTree = new AndTree();
        newTree.collection = andTree.collection;
        newTree.language = andTree.language;
        for (int i = 0; i < andTree.conditions.size(); ++i) {
            TreeTransformer.GCQLCondition condition = andTree.conditions.get(i);
            boolean found = false;
            for (TreeTransformer.GCQLCondition maxFactor : maxFactors) {
                if (!maxFactor.equals(condition)) continue;
                found = true;
                break;
            }
            if (found) continue;
            newTree.conditions.add(condition);
            newTree.sources.add(new LinkedHashSet(andTree.sources.get(i)));
        }
        return newTree;
    }

    private ArrayList<Set<String>> findShortestListOfSources(TreeTransformer.GCQLCondition factor, Set<Integer> referencedIn) throws CQLUnsupportedException {
        ArrayList<Set<String>> result = new ArrayList<Set<String>>();
        for (Integer treeSeqNum : referencedIn) {
            AndTree currentTree = this.subtrees.get(treeSeqNum);
            int pos = -1;
            for (int i = 0; i < currentTree.conditions.size(); ++i) {
                if (!currentTree.conditions.get(i).equals(factor)) continue;
                pos = i;
                break;
            }
            if (pos == -1) {
                throw new CQLUnsupportedException("This should not happen. There is a bug here!");
            }
            boolean found = false;
            for (Set<String> sourceSet : result) {
                HashSet<String> tmpSet = new HashSet<String>(sourceSet);
                tmpSet.retainAll((Collection)currentTree.sources.get(pos));
                if (tmpSet.size() <= 0) continue;
                sourceSet.retainAll((Collection)currentTree.sources.get(pos));
                found = true;
                break;
            }
            if (found) continue;
            result.add(new HashSet(currentTree.sources.get(pos)));
        }
        return result;
    }
}

