/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.searchsystem.workflow;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.execution.datatype.NamedDataType;
import gr.uoa.di.madgik.execution.exception.ExecutionException;
import gr.uoa.di.madgik.workflow.adaptor.search.WorkflowSearchAdaptor;
import gr.uoa.di.madgik.workflow.adaptor.search.searchsystemplan.DataSourceNode;
import gr.uoa.di.madgik.workflow.adaptor.search.searchsystemplan.OperatorNode;
import gr.uoa.di.madgik.workflow.adaptor.search.searchsystemplan.PlanNode;
import gr.uoa.di.madgik.workflow.adaptor.search.utils.wrappers.datasource.DataSourceWrapperFactoryConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.searchsystem.workflow.MatchReplacer;
import org.gcube.searchsystem.workflow.WorkflowEngineAdaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PE2ngWorkflowAdaptor
implements WorkflowEngineAdaptor {
    private static final Pattern PATTERN = Pattern.compile("(?<= =)(\\s*[^=-]*?)\\)");
    private static final String RESERVED = "RESERVED)";
    private static Logger logger = LoggerFactory.getLogger((String)WorkflowEngineAdaptor.class.getName());
    private WorkflowSearchAdaptor workflowSearchAdaptor;
    private EnvHintCollection hints = null;
    private DataSourceWrapperFactoryConfig cfg = null;
    public static Cache<String, String> planCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(30L, TimeUnit.MINUTES).build();

    public PE2ngWorkflowAdaptor(EnvHintCollection hints) throws Exception {
        this.hints = hints;
    }

    public PE2ngWorkflowAdaptor(DataSourceWrapperFactoryConfig cfg, EnvHintCollection hints) throws Exception {
        this.hints = hints;
        this.cfg = cfg;
    }

    static Map<String, String> getPlanQueriesMap(PlanNode planNode) {
        HashMap<String, String> queriesMapping = new HashMap<String, String>();
        if (planNode instanceof DataSourceNode) {
            String cqlQuery = ((DataSourceNode)planNode).getCqlInput().trim();
            String newCqlQuery = PE2ngWorkflowAdaptor.transformCQLQuery(cqlQuery.trim());
            if (queriesMapping.containsKey(newCqlQuery) && !((String)queriesMapping.get(newCqlQuery)).equalsIgnoreCase(cqlQuery)) {
                logger.error("found the same template for different queries : ");
                logger.error("template : " + newCqlQuery);
                logger.error("old1 : " + cqlQuery);
                logger.error("old2 : " + (String)queriesMapping.get(newCqlQuery));
                newCqlQuery = newCqlQuery.replace(RESERVED, "RESERVED)x");
                logger.error("new query will be : " + newCqlQuery);
            }
            queriesMapping.put(newCqlQuery, cqlQuery);
            ((DataSourceNode)planNode).setCqlInput(newCqlQuery);
        } else if (planNode instanceof OperatorNode) {
            for (PlanNode pn : ((OperatorNode)planNode).getChildren()) {
                queriesMapping.putAll(PE2ngWorkflowAdaptor.getPlanQueriesMap(pn));
            }
        }
        return queriesMapping;
    }

    void replacePlanNode(PlanNode planNode, Map<String, String> queriesMapping) {
        if (planNode instanceof DataSourceNode) {
            String cqlQuery = ((DataSourceNode)planNode).getCqlInput().trim();
            if (queriesMapping.containsKey(cqlQuery)) {
                ((DataSourceNode)planNode).setCqlInput(queriesMapping.get(cqlQuery));
            }
        } else if (planNode instanceof OperatorNode) {
            for (PlanNode pn : ((OperatorNode)planNode).getChildren()) {
                this.replacePlanNode(pn, queriesMapping);
            }
        }
    }

    private static String transformCQLQuery(String cqlQuery) {
        MatchReplacer replacer = new MatchReplacer(PATTERN){
            int i = 1;

            @Override
            public String replacement(MatchResult m) {
                return " RESERVED" + this.i++ + ")";
            }
        };
        logger.info("transformed query from: " + cqlQuery + '\n' + "to: " + replacer.replace(cqlQuery));
        return replacer.replace(cqlQuery);
    }

    private static String restoreCQLQuery(String cqlQuery, String transformedCQLQuery) {
        ArrayList<String> terms = new ArrayList<String>();
        Pattern pattern = Pattern.compile("(?<= =)(\\s*[^=-]*?)\\)");
        Matcher m = pattern.matcher(cqlQuery);
        while (m.find()) {
            for (int i = 1; i <= m.groupCount(); ++i) {
                terms.add(m.group(1));
            }
        }
        MatchReplacer replacer = new MatchReplacer(Pattern.compile("(?<= =)(\\s*[^=-]*?)\\)")){
            int i = 0;
            List<String> terms;

            @Override
            public String replacement(MatchResult m) {
                return this.terms.get(this.i++) + ')';
            }

            public MatchReplacer init(List<String> terms) {
                this.terms = terms;
                return this;
            }
        }.init(terms);
        return replacer.replace(transformedCQLQuery);
    }

    private String createWorkflow(PlanNode plan, boolean addInCache) throws Exception {
        long before = System.currentTimeMillis();
        this.workflowSearchAdaptor = this.cfg != null ? new WorkflowSearchAdaptor(this.cfg, this.hints) : new WorkflowSearchAdaptor(this.hints);
        long after = System.currentTimeMillis();
        logger.info("profiling: workflowsearchadaptor initialization time: " + (after - before) + " millis");
        before = System.currentTimeMillis();
        this.workflowSearchAdaptor.SetInputPlan(plan);
        this.workflowSearchAdaptor.CreatePlan();
        after = System.currentTimeMillis();
        logger.info("profiling: create plan time: " + (after - before) + " millis");
        logger.trace("-----------------------");
        logger.trace("template plan");
        logger.trace(this.workflowSearchAdaptor.GetCreatedPlan().Serialize());
        logger.trace("-----------------------");
        if (addInCache) {
            String cachedWorkflow = null;
            try {
                cachedWorkflow = WorkflowSearchAdaptor.serializePlan((Serializable)this.workflowSearchAdaptor);
            }
            catch (Exception e) {
                logger.error("Could not serialize workflow for cache", (Throwable)e);
                return null;
            }
            logger.info("cache element size : " + cachedWorkflow.length());
            planCache.put((Object)plan.toString(), (Object)cachedWorkflow);
            logger.info("cache has : " + planCache.asMap().keySet());
            return cachedWorkflow;
        }
        return null;
    }

    public String getExecutionResultSimple(PlanNode plan) throws Exception {
        this.workflowSearchAdaptor = this.cfg != null ? new WorkflowSearchAdaptor(this.cfg, this.hints) : new WorkflowSearchAdaptor(this.hints);
        this.workflowSearchAdaptor.SetInputPlan(plan);
        this.workflowSearchAdaptor.CreatePlan();
        String resultsetEpr = this.workflowSearchAdaptor.ExecutePlan();
        ExecutionException exception = this.workflowSearchAdaptor.GetCompletionError();
        if (exception != null) {
            throw exception;
        }
        return resultsetEpr;
    }

    @Override
    public String getExecutionResult(PlanNode plan) throws Exception {
        PlanNode copiedPlan = (PlanNode)plan.clone();
        Map<String, String> planQueriesMap = null;
        try {
            logger.info("called getExecutionResult with plan : " + copiedPlan.myToString());
            boolean workflowIsCached = false;
            long beforeTotalCreate = System.currentTimeMillis();
            long before = System.currentTimeMillis();
            long after = System.currentTimeMillis();
            planQueriesMap = PE2ngWorkflowAdaptor.getPlanQueriesMap(copiedPlan);
            logger.trace("executing plan after mapping: " + copiedPlan.myToString());
            logger.trace("executing plan after mapping: " + copiedPlan);
            logger.trace("planQueriesMap: " + planQueriesMap);
            String cachedWorkflow = (String)planCache.getIfPresent((Object)copiedPlan.toString());
            boolean serializableWorkflow = true;
            if (cachedWorkflow == null) {
                cachedWorkflow = this.createWorkflow(copiedPlan, true);
                if (cachedWorkflow == null) {
                    logger.error("error serializing the workflow");
                    serializableWorkflow = false;
                }
            } else {
                workflowIsCached = true;
            }
            before = System.currentTimeMillis();
            try {
                if (serializableWorkflow) {
                    this.workflowSearchAdaptor = (WorkflowSearchAdaptor)WorkflowSearchAdaptor.deserializePlan((String)cachedWorkflow);
                }
            }
            catch (Exception e) {
                logger.error("Error deserializing plan from cache. Will create it again");
                planCache.invalidateAll();
                this.createWorkflow(copiedPlan, false);
            }
            after = System.currentTimeMillis();
            logger.info("profiling: workflowSearchAdaptor deserialization time: " + (after - before) + " millis");
            before = System.currentTimeMillis();
            logger.trace("before replacement : " + this.workflowSearchAdaptor.getVariableCollection().ToXML());
            for (NamedDataType ndt : this.workflowSearchAdaptor.getVariableCollection()) {
                logger.trace("checking : " + ndt.Value.GetStringValue());
                if (!planQueriesMap.containsKey(ndt.Value.GetStringValue())) continue;
                logger.trace("replacing : " + ndt.Value.GetValue() + " with " + planQueriesMap.get(ndt.Value.GetStringValue()));
                ndt.Value.SetValue((Object)planQueriesMap.get(ndt.Value.GetStringValue()));
            }
            logger.trace("after replacement : " + this.workflowSearchAdaptor.getVariableCollection().ToXML());
            after = System.currentTimeMillis();
            logger.info("profiling: variable replacement time: " + (after - before) + " millis");
            long afterTotalCreate = System.currentTimeMillis();
            logger.info("profiling: create or get from cache execution plan time: " + (afterTotalCreate - beforeTotalCreate) + " millis");
            before = System.currentTimeMillis();
            String resultsetEpr = this.workflowSearchAdaptor.ExecutePlan();
            after = System.currentTimeMillis();
            logger.info("profiling: execute plan time: " + (after - before) + " millis");
            ExecutionException exception = this.workflowSearchAdaptor.GetCompletionError();
            if (workflowIsCached && (resultsetEpr == null || resultsetEpr.trim().length() == 0 || exception != null)) {
                logger.info("execution failed and workflow was cached. we are going to retry after clearing the cache first");
                planCache.invalidate((Object)copiedPlan.toString());
                return this.getExecutionResult(plan);
            }
            if (exception != null) {
                planCache.invalidate((Object)copiedPlan.toString());
                throw exception;
            }
            return resultsetEpr;
        }
        catch (Exception e) {
            logger.error("an exception happened. trying to run the old execution", (Throwable)e);
            return this.getExecutionResultSimple(plan);
        }
    }

    @Override
    public Object getExecutionPlan(PlanNode plan) throws Exception {
        this.workflowSearchAdaptor = this.cfg != null ? new WorkflowSearchAdaptor(this.cfg, this.hints) : new WorkflowSearchAdaptor(this.hints);
        this.workflowSearchAdaptor.SetInputPlan(plan);
        this.workflowSearchAdaptor.CreatePlan();
        return this.workflowSearchAdaptor.GetCreatedPlan();
    }
}

