import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.searchsystem.searchsystemservice.stubs.SearchResponse;
import org.gcube.searchsystem.searchsystemservice.stubs.SearchSystemServicePortType;
import org.gcube.searchsystem.searchsystemservice.stubs.service.SearchMasterServiceAddressingLocator;


public class Client {
	
	private static final String SEARCHURI = "http://dl07.di.uoa.gr:8000/wsrf/services/gcube/searchsystem/SearchSystemService";
	private static final String QUERY2 = "((((79697524-e3bf-457b-891a-faa3a9b0385f fuzzy pecies) or (79697524-e3bf-457b-891a-faa3a9b0385f contains image)) not (gDocCollectionID == c5b83790-f35f-11dd-9a37-9b05ac676cca)) and ((79697524-e3bf-457b-891a-faa3a9b0385f contains bassensis) and (d17294d8-654d-4435-ada4-fdc9d817f0ab contains Anampses))) project 79697524-e3bf-457b-891a-faa3a9b0385f d17294d8-654d-4435-ada4-fdc9d817f0ab";
	private static final String QUERY3 = "((((79697524-e3bf-457b-891a-faa3a9b0385f contains image) and (0da5e30a-a864-4686-9b5a-307db2c8c8a6 contains map))) and (((((gDocCollectionID == f7e075a0-9d84-11de-a010-bf56b4e46eb8) or (gDocCollectionID == c5b83790-f35f-11dd-9a37-9b05ac676cca))) and (gDocCollectionLang == en)))) project 79697524-e3bf-457b-891a-faa3a9b0385f";
	private static final String QUERY4 = "((((79697524-e3bf-457b-891a-faa3a9b0385f contains image) and (0da5e30a-a864-4686-9b5a-307db2c8c8a6 contains map))) and (((((gDocCollectionID == f7e075a0-9d84-11de-a010-bf56b4e46eb8) or (gDocCollectionID == c5b83790-f35f-11dd-9a37-9b05ac676cca))) and (gDocCollectionLang == en)))) project 79697524-e3bf-457b-891a-faa3a9b0385f";
	private static final String QUERY5 = "(((0caf1204-ff05-4508-9bab-65c3e93da60f geosearch/colID=\"cdabe220-a6ff-11e0-9d70-fda94ff03826\"/lang=\"en\"/inclusion=\"1\" \"10 10 10 1000 1000 1000 1000 10\") or (0caf1204-ff05-4508-9bab-65c3e93da60f geosearch/colID=\"cdabe220-a6ff-11e0-9d70-fda94ff03826\"/lang=\"en\"/inclusion=\"1\" \"10 10 10 500 500 500 500 10\")) and ((0caf1204-ff05-4508-9bab-65c3e93da60f geosearch/colID=\"cdabe220-a6ff-11e0-9d70-fda94ff03826\"/lang=\"en\"/inclusion=\"1\" \"1 1 1 500 500 500 500 1\") or (0caf1204-ff05-4508-9bab-65c3e93da60f geosearch/colID=\"cdabe220-a6ff-11e0-9d70-fda94ff03811\"/lang=\"en\"/inclusion=\"1\" \"-2 -6 -2 4 8 4 8 -6\"))) project 150fae0f-e0d7-4a01-bb9e-cacb4e5da9e0 b7f6b092-eed9-4a1f-b869-3f248034683c 49daf947-94fe-488f-84be-0308a3c46687";
	private static final String QUERY6 = "((((((0caf1204-ff05-4508-9bab-65c3e93da60f geosearch/colID=\"cdabe220-a6ff-11e0-9d70-fda94ff03826\"/lang=\"en\"/inclusion=\"1\" \"10 10 10 1000 1000 1000 1000 10\") " 
		+ "or (79697524-e3bf-457b-891a-faa3a9b0385f contains Pseudotolithus)) and "
		+ "((0caf1204-ff05-4508-9bab-65c3e93da60f geosearch/colID=\"cdabe220-a6ff-11e0-9d70-fda94ff03826\"/lang=\"en\"/inclusion=\"1\" \"10 10 10 1000 1000 1000 1000 10\") " 
		+ "or (79697524-e3bf-457b-891a-faa3a9b0385f contains cyclospilus))) "
		+ "not (gDocCollectionID == c5b83790-f35f-11dd-9a37-9b05ac676cca)) " 
		+ "or (79697524-e3bf-457b-891a-faa3a9b0385f exact \"*\")) "
		+ "or (79697524-e3bf-457b-891a-faa3a9b0385f fuzzy imape)) project 150fae0f-e0d7-4a01-bb9e-cacb4e5da9e0 b7f6b092-eed9-4a1f-b869-3f248034683c 49daf947-94fe-488f-84be-0308a3c46687 79697524-e3bf-457b-891a-faa3a9b0385f";
	private static final String QUERY = "((((79697524-e3bf-457b-891a-faa3a9b0385f exact \"*\") and " 
		+ "(79697524-e3bf-457b-891a-faa3a9b0385f contains Pseudotolithus)) or "
		+ "((79697524-e3bf-457b-891a-faa3a9b0385f exact \"*\") and " 
		+ "(79697524-e3bf-457b-891a-faa3a9b0385f contains cyclospilus))) or " 
		+ "(0caf1204-ff05-4508-9bab-65c3e93da60f geosearch/colID=\"cdabe220-a6ff-11e0-9d70-fda94ff03826\"/lang=\"en\"/inclusion=\"1\" \"10 10 10 1000 1000 1000 1000 10\")) ";
	
	
	public static void main(String args[]) {
		
		try {
			// Create endpoint reference to service
			EndpointReferenceType endpoint = new EndpointReferenceType();
			endpoint.setAddress(new Address(SEARCHURI));
			SearchSystemServicePortType sspt = new SearchMasterServiceAddressingLocator().getSearchSystemServicePortTypePort(endpoint);
			sspt = GCUBERemotePortTypeContext.getProxy(sspt, GCUBEScope.getScope(args[0]));

			SearchResponse resp = sspt.search(QUERY);
			
			String outRS_EPR = resp.getResultSetEpr();
			
			System.out.println(outRS_EPR);
			
			System.out.println("Warnings: ");
			if(resp.getWarnings() != null){
				String[] warnings = resp.getWarnings().getArray();
				if(warnings != null) {
					for(String warn : warnings) {
						System.out.println(warn);
					}
				}
			}
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
