/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.consumer.client.factory;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.gcube.rest.commons.helpers.XMLConverter;
import org.gcube.rest.commons.helpers.XPathEvaluator;
import org.gcube.search.sru.consumer.client.exception.SruConsumerClientException;
import org.gcube.search.sru.consumer.client.inject.SruConsumerClientModule;
import org.gcube.search.sru.consumer.common.apis.SruConsumerServiceFactoryAPI;
import org.gcube.search.sru.consumer.common.discoverer.SruConsumerDiscovererAPI;
import org.gcube.search.sru.consumer.common.resources.SruConsumerResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SruConsumerFactoryClient {
    private static Gson gson = new Gson();
    private String endpoint;
    private static final Logger logger = LoggerFactory.getLogger(SruConsumerFactoryClient.class);

    public String getEndpoint() {
        return this.endpoint;
    }

    SruConsumerFactoryClient(Builder builder) throws SruConsumerClientException {
        this.endpoint = builder.endpoint;
        SruConsumerDiscovererAPI discoverer = builder.discoverer;
        if (discoverer == null) {
            Injector injector = Guice.createInjector((Module[])new Module[]{new SruConsumerClientModule()});
            discoverer = (SruConsumerDiscovererAPI)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<SruConsumerDiscovererAPI<SruConsumerResource>>(){}));
        }
        if (builder.skipInitialize && builder.scope != null && this.endpoint != null) {
            logger.info("requested to skip the initialize part");
        } else {
            this.initialize((SruConsumerDiscovererAPI<SruConsumerResource>)discoverer, builder.scope);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initialize(SruConsumerDiscovererAPI<SruConsumerResource> discoverer, String scope) throws SruConsumerClientException {
        try {
            Set SruConsumerNodes = discoverer.discoverSruConsumerNodeRunningInstances(scope);
            ArrayList endpoints = Lists.newArrayList((Iterable)SruConsumerNodes);
            if (this.endpoint != null) {
                if (!endpoints.contains(this.endpoint)) throw new SruConsumerClientException("could not initialize random client. given endpoint : " + this.endpoint + " found endpoints : " + endpoints);
                endpoints = Lists.newArrayList((Object[])new String[]{this.endpoint});
            } else {
                Collections.shuffle(endpoints);
            }
            this.endpoint = (String)endpoints.get(0);
            logger.info("Initialized at : " + this.endpoint);
            return;
        }
        catch (Exception e) {
            logger.error("could not initialize random client", (Throwable)e);
            throw new SruConsumerClientException("could not initialize random client", e);
        }
    }

    public String createResource(SruConsumerResource resource, String scope) throws SruConsumerClientException {
        if (scope != null) {
            resource.setScope(scope);
        }
        String json = resource.toJSON();
        logger.info("calling create resource with json params : " + json);
        Response response = null;
        response = SruConsumerFactoryClient.getSruServiceFactoryProxy(this.endpoint).createResourceREST(scope, json);
        logger.info("createResource returned");
        if (response.getStatus() != Response.Status.CREATED.getStatusCode()) {
            String error = (String)response.readEntity(String.class);
            response.close();
            throw new SruConsumerClientException("resource could not be created : " + error);
        }
        String responseJSON = (String)response.readEntity(String.class);
        response.close();
        Map resp = (Map)gson.fromJson(responseJSON, new TypeToken<Map<String, String>>(){}.getType());
        logger.info("Created resource with id : " + (String)resp.get("resourceID"));
        String resourceID = (String)resp.get("resourceID");
        return resourceID;
    }

    private static SruConsumerServiceFactoryAPI getSruServiceFactoryProxy(String endpoint) throws SruConsumerClientException {
        ResteasyClient client = null;
        ResteasyWebTarget target = null;
        SruConsumerServiceFactoryAPI simple = null;
        logger.info("getting proxy from index factory service...");
        try {
            client = new ResteasyClientBuilder().build();
            target = client.target(endpoint);
            simple = (SruConsumerServiceFactoryAPI)target.proxy(SruConsumerServiceFactoryAPI.class);
        }
        catch (Exception e) {
            logger.error("Client could not connect to endpoint : " + endpoint, (Throwable)e);
            throw new SruConsumerClientException("Client could not connect to endpoint : " + endpoint, e);
        }
        logger.info("getting proxy from index factory service...OK");
        return simple;
    }

    public static class ResourceBuilder {
        private String schema;
        private String host;
        private Integer port;
        private String servlet;
        private String version;
        private Long maxRecords;
        private String defaultRecordSchema;
        private List<String> presentables;
        private List<String> searchables;
        private String recordIDField;
        private String scope;
        private String collectionID;
        private Map<String, String> mapping;
        private String snippetField;

        public ResourceBuilder snippetField(String snippetField) {
            this.snippetField = snippetField;
            return this;
        }

        public ResourceBuilder defaultRecordSchema(String defaultRecordSchema) {
            this.defaultRecordSchema = defaultRecordSchema;
            return this;
        }

        public ResourceBuilder collectionID(String collectionID) {
            this.collectionID = collectionID;
            return this;
        }

        public ResourceBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public ResourceBuilder host(String host) {
            this.host = host;
            return this;
        }

        public ResourceBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        public ResourceBuilder servlet(String servlet) {
            this.servlet = servlet;
            return this;
        }

        public ResourceBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ResourceBuilder maxRecords(Long maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public ResourceBuilder presentables(List<String> presentables) {
            this.presentables = presentables;
            return this;
        }

        public ResourceBuilder searchables(List<String> searchables) {
            this.searchables = searchables;
            return this;
        }

        public ResourceBuilder recordIDField(String recordIDField) {
            this.recordIDField = recordIDField;
            return this;
        }

        public ResourceBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public ResourceBuilder mapping(Map<String, String> mapping) {
            this.mapping = mapping;
            return this;
        }

        public SruConsumerResource build() {
            SruConsumerResource.DescriptionDocument descriptionDocument = new SruConsumerResource.DescriptionDocument();
            descriptionDocument.setSchema(this.schema);
            descriptionDocument.setHost(this.host);
            descriptionDocument.setPort(this.port);
            descriptionDocument.setServlet(this.servlet);
            descriptionDocument.setVersion(this.version);
            descriptionDocument.setMaxRecords(this.maxRecords);
            descriptionDocument.setDefaultRecordSchema(this.defaultRecordSchema);
            SruConsumerResource resource = new SruConsumerResource();
            resource.setDescriptionDocument(descriptionDocument);
            resource.setPresentables(this.presentables);
            resource.setSearchables(this.searchables);
            resource.setRecordIDField(this.recordIDField);
            resource.setCollectionID(this.collectionID);
            resource.setScope(this.scope);
            resource.setFields(this.createFields());
            resource.setCollections((List)Lists.newArrayList((Object[])new String[]{this.collectionID}));
            if (this.mapping == null || this.mapping.size() == 0) {
                resource.setIsCustomMapped(Boolean.valueOf(false));
            } else {
                resource.setMapping(this.mapping);
            }
            return resource;
        }

        private List<String> createFields() {
            Object f;
            String f2;
            ArrayList fields = Lists.newArrayList();
            String defaultLang = "unknown";
            String presentableType = "p";
            String searchableType = "s";
            logger.info("will create fields for the collection : " + this.collectionID);
            if (this.presentables != null) {
                for (String field : this.presentables) {
                    f2 = ResourceBuilder.constructField(this.collectionID, field, "unknown", "p");
                    logger.info("adding presentable field : " + f2);
                    fields.add(f2);
                }
            }
            if (this.snippetField != null) {
                f = ResourceBuilder.constructField(this.collectionID, "S", "unknown", "p");
                logger.info("adding presentable field : " + (String)f);
                fields.add(f);
            }
            if (this.searchables != null) {
                for (String field : this.searchables) {
                    f2 = ResourceBuilder.constructField(this.collectionID, field, "unknown", "s");
                    logger.info("adding searchable field : " + f2);
                    fields.add(f2);
                }
            }
            f = ResourceBuilder.constructField(this.collectionID, "allIndexes", "unknown", "s");
            logger.info("adding searchable field : " + (String)f);
            fields.add(f);
            return fields;
        }

        static String constructField(String collectionID, String field, String language, String type) {
            return collectionID + ":" + language + ":" + type + ":" + field;
        }

        public static SruConsumerResource createResourceFromExplain(String schema, String host, Integer port, String servlet, String collectionID) throws URISyntaxException, IOException {
            String urlString = ResourceBuilder.constructExplainURLString(schema, host, port, servlet);
            String xml = IOUtils.toString((URI)new URI(urlString), (String)"UTF-8");
            XPathEvaluator eval = new XPathEvaluator(XMLConverter.stringToNode((String)xml));
            List indexes = null;
            indexes = eval.evaluate("/explainResponse/record/recordData/explain/indexInfo/index/title/text()");
            List schemas = eval.evaluate("/explainResponse/record/recordData/explain/schemaInfo/schema/['identifier']");
            String version = null;
            try {
                version = (String)eval.evaluate("/explainResponse/version/text()").get(0);
            }
            catch (Exception e) {
                logger.warn("error while getting version");
            }
            Long maximumRecords = null;
            try {
                maximumRecords = Long.valueOf((String)eval.evaluate("/explainResponse/record/recordData/explain/configInfo/default[@type='maximumRecords']/text()").get(0));
            }
            catch (Exception e) {
                logger.warn("error while getting maximumRecords");
            }
            String retrieveSchema = null;
            try {
                retrieveSchema = (String)eval.evaluate("/explainResponse/record/recordData/explain/configInfo/default[@type='retrieveSchema']/text()").get(0);
            }
            catch (Exception e) {
                logger.warn("error while getting retrieveSchema");
            }
            logger.info("maximumRecords : " + maximumRecords);
            logger.info("schemas : " + schemas);
            logger.info("maximumRecords : " + maximumRecords);
            logger.info("retrieveSchema : " + retrieveSchema);
            logger.info("indexes : " + indexes);
            SruConsumerResource resource = new ResourceBuilder().schema(schema).host(host).port(port).servlet(servlet).collectionID(collectionID).maxRecords(maximumRecords).version(version).defaultRecordSchema(retrieveSchema).searchables(indexes).presentables(indexes).recordIDField("id").build();
            return resource;
        }

        static String constructExplainURLString(String schema, String host, Integer port, String servlet) throws URISyntaxException {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append("operation=explain");
            logger.info("uri : " + strBuf);
            String url = strBuf.toString();
            URI uri = new URI(schema, null, host, port, "/" + servlet, url, null);
            return uri.toString();
        }
    }

    public static class Builder {
        private String endpoint;
        private String scope;
        private boolean skipInitialize = false;
        private final SruConsumerDiscovererAPI<SruConsumerResource> discoverer;

        public Builder() {
            this.discoverer = null;
        }

        @Inject
        public Builder(SruConsumerDiscovererAPI<SruConsumerResource> discoverer) {
            this.discoverer = discoverer;
        }

        public Builder endpoint(String endpoint) {
            if (endpoint.endsWith("/")) {
                endpoint = endpoint.substring(0, endpoint.length() - 1);
            }
            this.endpoint = endpoint;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder skipInitialize(boolean skipInitialize) {
            this.skipInitialize = skipInitialize;
            return this;
        }

        public SruConsumerFactoryClient build() throws SruConsumerClientException {
            return new SruConsumerFactoryClient(this);
        }
    }
}

