/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.db;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringEscapeUtils;
import org.gcube.rest.commons.helpers.XMLConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class RecordConverter {
    static final Logger logger = LoggerFactory.getLogger(RecordConverter.class);
    static final List<String> DC_FIELDS = Lists.newArrayList((Object[])new String[]{"title", "creator", "subject", "description", "publisher", "contributor", "date", "type", "format", "identifier", "source", "language", "relation", "coverage", "rights"});

    public String convertRecordsToSru(Long resultsCnt, List<Map<String, String>> rs, boolean splitLists) throws TransformerException, ParserConfigurationException {
        return RecordConverter.convertRecordsToSRU((Long)resultsCnt, rs, (boolean)splitLists);
    }

    static String convertRecordsToSRU(Long resultsCnt, List<Map<String, String>> rs, boolean splitLists) throws TransformerException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        doc.setXmlStandalone(true);
        Element searchRetrieveResponse = doc.createElement("searchRetrieveResponse");
        searchRetrieveResponse.setAttribute("xmlns:zs", "http://www.loc.gov/zing/srw/");
        doc.appendChild(searchRetrieveResponse);
        Element el = doc.createElement("zs:version");
        el.appendChild(doc.createTextNode("1.1"));
        searchRetrieveResponse.appendChild(el);
        Element records = doc.createElement("zs:records");
        searchRetrieveResponse.appendChild(records);
        el = doc.createElement("zs:numberOfRecords");
        el.appendChild(doc.createTextNode(String.valueOf(resultsCnt)));
        searchRetrieveResponse.appendChild(el);
        int recPosition = 1;
        for (Map<String, String> rec : rs) {
            Element record = doc.createElement("zs:record");
            records.appendChild(record);
            el = doc.createElement("zs:recordSchema");
            el.appendChild(doc.createTextNode("info:srw/schema/1/dc-v1.1"));
            record.appendChild(el);
            el = doc.createElement("zs:recordPacking");
            el.appendChild(doc.createTextNode("xml"));
            record.appendChild(el);
            Element recordData = doc.createElement("zs:recordData");
            record.appendChild(recordData);
            Element dc = doc.createElement("srw_dc:dc");
            dc.setAttribute("xmlns:srw_dc", "info:srw/schema/1/dc-schema");
            dc.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            dc.setAttribute("xmlns", "http://purl.org/dc/elements/1.1/");
            dc.setAttribute("xsi:schemaLocation", "info:srw/schema/1/dc-schema http://www.loc.gov/standards/sru/resources/dc-schema.xsd");
            recordData.appendChild(dc);
            for (Map.Entry<String, String> col : rec.entrySet()) {
                String columnName = col.getKey();
                String value = col.getValue();
                columnName = StringEscapeUtils.escapeXml((String)columnName);
                if (!DC_FIELDS.contains(columnName = columnName.toLowerCase())) {
                    logger.info("field : " + columnName + " not in dc");
                    continue;
                }
                if (value == null || value.trim().length() == 0) {
                    logger.info("field : " + columnName + " has no value");
                    continue;
                }
                if (value.startsWith("[") && value.endsWith("]") && splitLists) {
                    List values = Splitter.on((String)", ").trimResults().splitToList((CharSequence)value.substring(1, value.length() - 1));
                    for (String singleVal : values) {
                        Element node = doc.createElement(columnName);
                        logger.debug("nodeToString : " + XMLConverter.nodeToString((Node)node));
                        String xml = StringEscapeUtils.escapeXml((String)singleVal);
                        node.appendChild(doc.createTextNode(xml));
                        dc.appendChild(node);
                    }
                    continue;
                }
                Element node = doc.createElement(columnName);
                logger.debug("nodeToString : " + XMLConverter.nodeToString((Node)node));
                String xml = StringEscapeUtils.escapeXml((String)value);
                node.appendChild(doc.createTextNode(xml));
                dc.appendChild(node);
            }
            Element recordPosition = doc.createElement("zs:recordPosition");
            recordPosition.appendChild(doc.createTextNode(String.valueOf(recPosition)));
            record.appendChild(recordPosition);
            ++recPosition;
        }
        DOMSource domSource = new DOMSource(doc);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        transformer.transform(domSource, sr);
        return sw.toString();
    }

    static String convertRecordsToRSS(Long resultsCnt, List<Map<String, String>> rs) throws TransformerException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        doc.setXmlStandalone(true);
        Element searchRetrieveResponse = doc.createElement("searchRetrieveResponse");
        searchRetrieveResponse.setAttribute("xmlns:zs", "http://www.loc.gov/zing/srw/");
        doc.appendChild(searchRetrieveResponse);
        Element el = doc.createElement("zs:version");
        el.appendChild(doc.createTextNode("1.1"));
        searchRetrieveResponse.appendChild(el);
        Element records = doc.createElement("zs:records");
        searchRetrieveResponse.appendChild(records);
        el = doc.createElement("zs:numberOfRecords");
        el.appendChild(doc.createTextNode(String.valueOf(resultsCnt)));
        searchRetrieveResponse.appendChild(el);
        int recPosition = 1;
        for (Map<String, String> rec : rs) {
            Element record = doc.createElement("zs:record");
            records.appendChild(record);
            el = doc.createElement("zs:recordSchema");
            el.appendChild(doc.createTextNode("rss"));
            record.appendChild(el);
            el = doc.createElement("zs:recordPacking");
            el.appendChild(doc.createTextNode("xml"));
            record.appendChild(el);
            Element recordData = doc.createElement("zs:recordData");
            record.appendChild(recordData);
            Element srw = doc.createElement("srw_rss:rss");
            srw.setAttribute("xmlns:srw_rss", "rss");
            srw.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            srw.setAttribute("xmlns", "rss");
            recordData.appendChild(srw);
            for (Map.Entry<String, String> col : rec.entrySet()) {
                String columnName = col.getKey();
                String value = col.getValue();
                String xmlColumn = StringEscapeUtils.escapeXml((String)columnName);
                Element node = doc.createElement(xmlColumn);
                logger.debug("nodeToString : " + XMLConverter.nodeToString((Node)node));
                if (value == null) {
                    node.appendChild(doc.createTextNode(""));
                } else {
                    String xml = StringEscapeUtils.escapeXml((String)value.toString());
                    node.appendChild(doc.createTextNode(xml));
                }
                srw.appendChild(node);
            }
            Element recordPosition = doc.createElement("zs:recordPosition");
            recordPosition.appendChild(doc.createTextNode(String.valueOf(recPosition)));
            record.appendChild(recordPosition);
            ++recPosition;
        }
        DOMSource domSource = new DOMSource(doc);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        transformer.transform(domSource, sr);
        return sw.toString();
    }
}

