/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.search.adapter.client.factory;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.gcube.search.sru.search.adapter.client.exception.SruSearchAdapterClientException;
import org.gcube.search.sru.search.adapter.client.inject.SruSearchAdapterClientModule;
import org.gcube.search.sru.search.adapter.commons.apis.SruSearchAdapterServiceFactoryAPI;
import org.gcube.search.sru.search.adapter.commons.discoverer.SruSearchAdapterDiscovererAPI;
import org.gcube.search.sru.search.adapter.commons.resources.SruSearchAdapterResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SruSearchAdapterFactoryClient {
    private static Gson gson = new Gson();
    private String endpoint;
    private static final Logger logger = LoggerFactory.getLogger(SruSearchAdapterFactoryClient.class);

    public String getEndpoint() {
        return this.endpoint;
    }

    SruSearchAdapterFactoryClient(Builder builder) throws SruSearchAdapterClientException {
        this.endpoint = builder.endpoint;
        SruSearchAdapterDiscovererAPI discoverer = builder.discoverer;
        if (discoverer == null) {
            Injector injector = Guice.createInjector((Module[])new Module[]{new SruSearchAdapterClientModule()});
            discoverer = (SruSearchAdapterDiscovererAPI)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<SruSearchAdapterDiscovererAPI<SruSearchAdapterResource>>(){}));
        }
        this.initialize((SruSearchAdapterDiscovererAPI<SruSearchAdapterResource>)discoverer, builder.scope);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initialize(SruSearchAdapterDiscovererAPI<SruSearchAdapterResource> discoverer, String scope) throws SruSearchAdapterClientException {
        try {
            Set srudbNodes = discoverer.discoverSruSearchAdapterNodeRunningInstances(scope);
            ArrayList endpoints = Lists.newArrayList((Iterable)srudbNodes);
            if (this.endpoint != null) {
                if (!endpoints.contains(this.endpoint)) throw new SruSearchAdapterClientException("could not initialize random client. given endpoint : " + this.endpoint + " found endpoints : " + endpoints);
                endpoints = Lists.newArrayList((Object[])new String[]{this.endpoint});
            } else {
                Collections.shuffle(endpoints);
            }
            this.endpoint = (String)endpoints.get(0);
            logger.info("Initialized at : " + this.endpoint);
            return;
        }
        catch (Exception e) {
            logger.error("could not initialize random client", (Throwable)e);
            throw new SruSearchAdapterClientException("could not initialize random client", e);
        }
    }

    public String createResource(SruSearchAdapterResource resource, String scope) throws SruSearchAdapterClientException {
        if (scope != null) {
            resource.setScope(scope);
        }
        String json = resource.toJSON();
        logger.info("calling create resource with json params : " + json);
        Response response = null;
        response = SruSearchAdapterFactoryClient.getSruServiceFactoryProxy(this.endpoint).createResourceREST(scope, json);
        logger.info("createResource returned");
        if (response.getStatus() != Response.Status.CREATED.getStatusCode()) {
            String error = (String)response.readEntity(String.class);
            response.close();
            throw new SruSearchAdapterClientException("resource could not be created : " + error);
        }
        String responseJSON = (String)response.readEntity(String.class);
        response.close();
        Map resp = (Map)gson.fromJson(responseJSON, new TypeToken<Map<String, String>>(){}.getType());
        logger.info("Created resource with id : " + (String)resp.get("resourceID"));
        String resourceID = (String)resp.get("resourceID");
        return resourceID;
    }

    private static SruSearchAdapterServiceFactoryAPI getSruServiceFactoryProxy(String endpoint) throws SruSearchAdapterClientException {
        ResteasyClient client = null;
        ResteasyWebTarget target = null;
        SruSearchAdapterServiceFactoryAPI simple = null;
        logger.info("getting proxy from index factory service...");
        try {
            client = new ResteasyClientBuilder().build();
            target = client.target(endpoint);
            simple = (SruSearchAdapterServiceFactoryAPI)target.proxy(SruSearchAdapterServiceFactoryAPI.class);
        }
        catch (Exception e) {
            logger.error("Client could not connect to endpoint : " + endpoint, (Throwable)e);
            throw new SruSearchAdapterClientException("Client could not connect to endpoint : " + endpoint, e);
        }
        logger.info("getting proxy from index factory service...OK");
        return simple;
    }

    public static class Builder {
        private String endpoint;
        private String scope;
        private final SruSearchAdapterDiscovererAPI<SruSearchAdapterResource> discoverer;

        public Builder() {
            this.discoverer = null;
        }

        @Inject
        public Builder(SruSearchAdapterDiscovererAPI<SruSearchAdapterResource> discoverer) {
            this.discoverer = discoverer;
        }

        public Builder endpoint(String endpoint) {
            if (endpoint.endsWith("/")) {
                endpoint = endpoint.substring(0, endpoint.length() - 1);
            }
            this.endpoint = endpoint;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public SruSearchAdapterFactoryClient build() throws SruSearchAdapterClientException {
            return new SruSearchAdapterFactoryClient(this);
        }
    }
}

