/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.admin;

import gr.forth.ics.isl.xsearch.resources.Resources;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ChangeEndpoint
extends HttpServlet {
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String newEndpoint;
        response.setContentType("text/html;charset=UTF-8");
        HttpSession session = request.getSession();
        String loggedin = (String)session.getAttribute("loggedin");
        if (loggedin == null) {
            loggedin = "no";
            session.setAttribute("loggedin", (Object)loggedin);
            RequestDispatcher dispatcher = request.getRequestDispatcher("login.jsp");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        PrintWriter out = response.getWriter();
        out.print("");
        String category = request.getParameter("category");
        if (category == null) {
            category = "";
        }
        if ((newEndpoint = request.getParameter("endpoint")) == null) {
            newEndpoint = "";
        }
        newEndpoint = URLDecoder.decode(newEndpoint, "utf-8");
        try {
            URL url = new URL(newEndpoint);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            String xml_content = "application/sparql-results+xml";
            connection.setRequestProperty("ACCEPT", xml_content);
            int endpointResponseCode = connection.getResponseCode();
            String endpointResponseMess = connection.getResponseMessage();
            String sampleQ = "select ?x where { ?x ?y ?z } limit 1";
            sampleQ = URLEncoder.encode(sampleQ, "utf8");
            String sampleQpath = newEndpoint + sampleQ;
            System.out.println("# Sample query path: " + sampleQpath);
            url = new URL(sampleQpath);
            connection = (HttpURLConnection)url.openConnection();
            int sampleQResponseCode = connection.getResponseCode();
            String sampleQResponseMess = connection.getResponseMessage();
            System.out.println("# Endpoint response code: " + endpointResponseCode);
            System.out.println("# Sample query response code:" + sampleQResponseMess);
            if (!(endpointResponseCode != 400 && endpointResponseCode != 500 && endpointResponseCode != 200 || sampleQResponseCode != 400 && sampleQResponseCode != 200)) {
                Resources.SPARQL_ENDPOINTS.put(category, newEndpoint);
            } else if (endpointResponseCode != 400 || endpointResponseCode != 500 || endpointResponseCode != 200) {
                out.print("Not a SPARQL endpoint! Please check it!");
            } else {
                out.print("Could not run the sample query! Message: " + sampleQResponseMess + ". <br />(The path of the endpoint must be ready to accept a query, e.g. it must end with 'query=')");
            }
        }
        catch (Exception e) {
            out.print(e.getMessage().replace("\n", " "));
        }
        out.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

