/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch;

import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.parser.PdfTextExtractor;
import gr.forth.ics.isl.xsearch.IOSLog;
import gr.forth.ics.isl.xsearch.util.HTMLTag;
import java.net.URL;
import java.net.URLConnection;

public class SearchResult {
    private String title;
    private String url;
    private String description;
    private int rank;
    private String content;
    private boolean hasRetrieved;

    public SearchResult(String title, String url, String description, int rank) {
        this.title = title;
        this.url = url;
        this.description = description;
        this.rank = rank;
        this.content = title + "  " + description;
        this.hasRetrieved = false;
    }

    public SearchResult() {
        this.title = "";
        this.url = "";
        this.description = "";
        this.rank = -1;
        this.content = "";
        this.hasRetrieved = false;
    }

    public void retriveContent() {
        try {
            URL the_url = new URL(this.url);
            URLConnection urlConn = the_url.openConnection();
            String source = "";
            if (urlConn.getContentType().equalsIgnoreCase("application/pdf")) {
                System.out.println("# Reading PDF file!");
                try {
                    PdfReader reader = new PdfReader(the_url);
                    int n = reader.getNumberOfPages();
                    for (int i = 1; i <= n; ++i) {
                        source = source + PdfTextExtractor.getTextFromPage((PdfReader)reader, (int)i) + "\n";
                    }
                    reader.close();
                }
                catch (Exception e) {
                    System.out.println("*** ERROR READING PDF CONTENT: " + e.getMessage());
                }
            } else if (!urlConn.getContentType().equalsIgnoreCase("application/msword")) {
                HTMLTag tagger = new HTMLTag(the_url);
                source = tagger.getSourceCode();
            }
            if (source == null) {
                return;
            }
            source = source.replace("<?xml ", "<html ");
            this.addContent(source);
            this.hasRetrieved = true;
        }
        catch (Exception e) {
            IOSLog.writeErrorToLog((Exception)e, (String)"SearchResult");
            System.out.println("*** ERROR RETRIEVING THE CONTENT OF: " + this.url + "\n" + e.getMessage());
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void addContent(String content) {
        this.content = this.content + " | " + content;
        this.hasRetrieved = true;
    }

    public boolean isHasRetrieved() {
        return this.hasRetrieved;
    }

    public void setHasRetrieved(boolean hasRetrieved) {
        this.hasRetrieved = hasRetrieved;
    }
}

