/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.mining;

import gr.forth.ics.isl.textentitymining.Category;
import gr.forth.ics.isl.textentitymining.Entity;
import gr.forth.ics.isl.textentitymining.gate.GateEntityMiner;
import gr.forth.ics.isl.xsearch.Bean_Search;
import gr.forth.ics.isl.xsearch.IOSLog;
import gr.forth.ics.isl.xsearch.SearchResult;
import gr.forth.ics.isl.xsearch.resources.Resources;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class Servlet_MinePage
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        Servlet_MinePage servlet_MinePage = this;
        synchronized (servlet_MinePage) {
            try (PrintWriter out = response.getWriter();){
                HashMap templateQueries;
                int doc = Integer.parseInt(request.getParameter("doc"));
                System.out.println("# Mining Result: " + doc);
                HttpSession session = request.getSession();
                HashSet acceptedCategories = (HashSet)session.getAttribute("acceptedCategories");
                if (acceptedCategories == null) {
                    acceptedCategories = Resources.MINING_ACCEPTED_CATEGORIES;
                }
                if ((templateQueries = (HashMap)session.getAttribute("templateQueries")) == null) {
                    templateQueries = Resources.SPARQL_TEMPLATES;
                }
                String query = (String)session.getAttribute("submitted_query");
                this.updateLog(request, query, doc);
                Bean_Search results = (Bean_Search)session.getAttribute("entities");
                if (results == null) {
                    results = new Bean_Search((String)session.getAttribute("resultsFirstPage"));
                    session.setAttribute("entities", (Object)results);
                } else if (((String)session.getAttribute("query_submitted")).equals("no")) {
                    results = new Bean_Search((String)session.getAttribute("resultsFirstPage"));
                    session.setAttribute("entities", (Object)results);
                }
                SearchResult result = (SearchResult)results.getWseResults().get(doc);
                String title = result.getTitle();
                String descr = result.getDescription();
                String url = result.getUrl();
                if (!result.isHasRetrieved()) {
                    System.out.println("# Retrieving result's content....");
                    result.retriveContent();
                }
                String content = result.getContent();
                out.println("<font><a href='" + url + "'>" + title + "</a></font>&nbsp;&nbsp;<a href='javascript:getAllResults()'><font class='em_reset'>reset</font></a>");
                if (!descr.trim().equals("")) {
                    out.println("<br />");
                    out.println("<font>" + descr + "</font>");
                }
                out.println("<br />");
                out.println("<font class='em_url'>" + url + "</font>");
                out.println("<br />&nbsp;<br />");
                out.println("<font class='em_entities_title'>Entities: </font>");
                out.println("<br />&nbsp;<br />");
                ArrayList entities = new ArrayList();
                try {
                    GateEntityMiner miner = new GateEntityMiner();
                    miner.setTextToMine(content);
                    miner.setAcceptedCategories((Set)acceptedCategories);
                    miner.findEntities();
                    entities = miner.getEntities();
                }
                catch (Exception ex) {
                    System.out.println("*** PROBLEM ADDING DOCUMENTS TO CORPUS:");
                }
                if (entities.isEmpty()) {
                    out.println("<font color='red'><i>No entities were found!</i></font>");
                } else {
                    for (Category cat : entities) {
                        String category = cat.getName();
                        out.println("<font class='em_category_name'>" + category + "</font>");
                        out.println("<br />");
                        int n = 0;
                        for (Entity ent : cat.getEntities()) {
                            String name = ent.getName();
                            name = name.replace("'", "&quot;").replace("\"", "&quot;");
                            String element_name = category.trim().replace(" ", "_") + "_" + n;
                            String element_name_pass = name.replace("\"", "&quot;").replace("'", "&quot;").replace("%", "^^^^^");
                            String element_img_id = category.toLowerCase().trim().replace(" ", "_").replace(".", "") + "_imgp_" + ++n;
                            out.println("&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"javascript:checkElement('" + name + "','" + element_name + "'," + doc + ");\"><font class='em_element_name'>" + name + "</font></a>");
                            if (templateQueries.containsKey(category)) {
                                out.println("<a id=\"" + element_img_id + "\" href=\"javascript:inspectElement('" + category + "', '" + element_name_pass + "', '" + element_img_id + "')\"><img border=\"0\" title=\"Click to retrieve semantic information\" src=\"files/graphics/lod.jpg\"/></a>");
                            }
                            out.println("<br />");
                            out.println("<div class=\"entity_instance\" id=\"" + element_name + "\"></div>");
                        }
                        out.println("<br />");
                    }
                }
                out.println("<br />&nbsp;<br />&nbsp;<br />&nbsp;<br />");
            }
        }
    }

    public void updateLog(HttpServletRequest request, String query, int pageid) {
        String ip = request.getRemoteAddr();
        String date = IOSLog.getCurrentDate();
        String line = "\nx-search\t" + date + "\t" + ip + "\t" + query + "\tMINE PAGE " + pageid;
        IOSLog.writeToLog((String)line);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

